﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Globalization;
using System.Xml.Linq;

namespace Nintendo.InGameEditing.Communication.Htcs
{
    internal class CommandResult
    {
        private readonly string RequestName;
        private readonly uint Value;

        public const string XElementName = "CommandResult";

        public CommandResult(XElement xElement)
        {
            Value = uint.Parse(xElement.Element("Value").Value, CultureInfo.InvariantCulture);
            RequestName = xElement.Element("RequestName").Value;
        }

        public CommandResult(string requestName, uint value)
        {
            Value = value;
            RequestName = requestName;
        }

        public XElement ToXElement()
        {
            return new XElement(XElementName, this, new XElement("Value", Value), new XElement("RequestName", RequestName));
        }

        public uint GetValue()
        {
            return Value;
        }

        public string GetName()
        {
            return RequestName;
        }
    }
}
