﻿using System;
using System.Diagnostics.CodeAnalysis;

namespace Nintendo.Atk.Binary
{
    /// <summary>
    /// Opus データ内の情報タイプです。
    /// </summary>
    public enum AudioOpusInfoType : uint
    {
        /// <summary>
        /// 基本情報。
        /// </summary>
        BasicInfo = 0x80000001,

        /// <summary>
        /// Nintendo.Atk では、現在この定義をサポートしていません。
        /// 使用しないでください。
        /// </summary>
        OffsetInfo = 0x80000002,

        /// <summary>
        /// Nintendo.Atk では、現在この定義をサポートしていません。
        /// 使用しないでください。
        /// </summary>
        ContextInfo = 0x80000003,

        /// <summary>
        /// データ本体。
        /// Nintendo.Atk では、現在この定義をサポートしていません。
        /// 使用しないでください。
        /// </summary>
        DataInfo = 0x80000004,
    }
}
