﻿namespace Nintendo.Atk.Binary
{
    /// <summary>
    /// OpusInfo の基本クラスです。
    /// </summary>
    /// <typeparam name="TBody">OpusInfo ボディの型。</typeparam>
    public class AudioOpusInfo<TBody>
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        protected AudioOpusInfo(AudioOpusInfoType type, int size, TBody body)
        {
            this.Header = new AudioOpusInfoHeader(type, size);
            this.Body = body;
        }

        /// <summary>
        /// OpusInfo ヘッダ。
        /// </summary>
        public AudioOpusInfoHeader Header { get; private set; }

        /// <summary>
        /// OpusInfo ボディ。
        /// </summary>
        public TBody Body { get; private set; }
    }
}
