﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.Foundation.Contracts;

namespace Nintendo.Atk.Binary
{
    internal static class AtkNativeWaveBinaryInfoExtension
    {
        public static WaveBinaryInfo ToWaveBinaryInfo(this AtkNativeWaveBinaryInfo target)
        {
            Ensure.Operation.True(target.SampleCount <= int.MaxValue);
            Ensure.Operation.True(target.LoopStartFrame <= int.MaxValue);
            Ensure.Operation.True(target.LoopEndFrame <= int.MaxValue);

            return new WaveBinaryInfo()
            {
                Format = target.Format.ToWaveFormat(),
                SampleCount = target.SampleCount,
                HasLoop = target.HasLoop,
                LoopStartFrame = target.LoopStartFrame,
                LoopEndFrame = target.LoopEndFrame,
                OriginalLoopStartFrame = target.OriginalLoopStartFrame,
                OriginalLoopEndFrame = target.OriginalLoopEndFrame,
            };
        }

        private static WaveFormat ToWaveFormat(this AtkNativeWaveFormat target)
        {
            return new WaveFormat()
            {
                Encoding = target.Encoding,
                ChannelCount = target.ChannelCount,
                Samplerate = target.Samplerate,
            };
        }
    }
}
