﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.Foundation.Contracts;

namespace Nintendo.Atk.Binary
{
    /// <summary>
    /// 波形フォーマット情報を格納します。
    /// </summary>
    public class WaveFormat
    {
        /// <summary>
        /// エンコーディング文字列の最大長です。
        /// </summary>
        public const int MaxEncodingLength = 8;

        private string encoding = string.Empty;

        /// <summary>
        /// エンコーディングの定義を格納します。
        /// </summary>
        public static class Encodings
        {
            /// <summary>
            /// PCM16
            /// </summary>
            public const string PCM16 = "PCM16";

            /// <summary>
            /// ADPCM
            /// </summary>
            public const string ADPCM = "ADPCM";
        }

        /// <summary>
        /// エンコーディングを取得または設定します。
        /// エンコーディングは MaxEncodingLength 文字以内にする必要があります。
        /// </summary>
        public string Encoding
        {
            get { return this.encoding; }

            set
            {
                Ensure.Argument.NotNull(value);
                Ensure.Argument.True(value.Length <= MaxEncodingLength);
                this.encoding = value;
            }
        }

        /// <summary>
        /// チャンネル数を取得または設定します。
        /// </summary>
        public int ChannelCount { get; set; }

        /// <summary>
        /// サンプルレートを取得または設定します。
        /// </summary>
        public int Samplerate { get; set; }
    }
}
