﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Runtime.InteropServices;

namespace Nintendo.Atk.Binary
{
    /// <summary>
    /// 波形バイナリ情報を格納します。
    /// </summary>
    public class WaveBinaryInfo
    {
        /// <summary>
        /// 波形フォーマットを取得または設定します。
        /// </summary>
        public WaveFormat Format { get; set; }

        /// <summary>
        /// サンプル数を取得または設定します。
        /// </summary>
        public long SampleCount { get; set; }

        /// <summary>
        /// ループの有無を取得または設定します。
        /// </summary>
        public bool HasLoop { get; set; }

        /// <summary>
        /// ループ開始位置を取得または設定します。
        /// </summary>
        public long LoopStartFrame { get; set; }

        /// <summary>
        /// ループ終了位置を取得または設定します。
        /// </summary>
        public long LoopEndFrame { get; set; }

        /// <summary>
        /// ループ補正前のループ開始位置を取得または設定します。
        /// </summary>
        public long OriginalLoopStartFrame { get; set; }

        /// <summary>
        /// ループ補正前のループ終了位置を取得または設定します。
        /// </summary>
        public long OriginalLoopEndFrame { get; set; }
    }
}
