﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/util/util_BinaryFormat.h>
#include <nn/atk/atk_WaveFileReader.h>
#include "atkTool_Result.h"

struct nnatktoolWaveBinaryInfo;

namespace nn { namespace atkTool { namespace detail {

class BfwavReader
{
public:
    NN_IMPLICIT BfwavReader(const void* pBfwavData);

    bool IsAvailable() const { return m_IsAvailable; }

    nnatktoolResult GetWaveBinaryInfo(nnatktoolWaveBinaryInfo& info) const;

    size_t GetRequiredBufferSizeForDecodeAll() const
    {
        return GetSampleCount() * sizeof(int16_t);
    }

    nnatktoolResult DecodeAll(int channel, void* outputBuffer, size_t outputBufferSize) const;

private:
    int32_t GetSampleCount() const
    {
        return static_cast<int32_t>(m_WaveInfo.loopEndFrame);
    }

private:
    nn::atk::detail::WaveFileReader m_Reader;
    nn::atk::detail::WaveInfo m_WaveInfo;
    bool m_IsAvailable;
};

} } }
