﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/util/util_BinaryFormat.h>
#include <nn/atk/atk_StreamSoundFileReader.h>
#include "atkTool_Result.h"

struct nnatktoolWaveBinaryInfo;

namespace nn { namespace atkTool { namespace detail {

class BfstmReader
{
public:
    NN_IMPLICIT BfstmReader(const void* pBfstmData);

    bool IsAvailable() const { return m_IsAvailable; }

    void GetWaveBinaryInfo(nnatktoolWaveBinaryInfo& info) const;

    size_t GetRequiredBufferSizeForDecodeAll() const
    {
        return GetSampleCount() * sizeof(int16_t);
    }

    nnatktoolResult DecodeAll(int channel, void* outputBuffer, size_t outputBufferSize) const;

private:
    int32_t GetSampleCount() const
    {
        return m_StreamSoundInfo.frameCount;
    }

    bool IsLastBlock(int block) const;

    // ブロックサイズを取得します。
    size_t GetBlockSize() const
    {
        return m_StreamSoundInfo.channelCount * m_StreamSoundInfo.oneBlockBytes;
    }

    // ブロックに含まれるチャンネルごとのデータサイズを取得します。
    size_t GetDataSizeForBlockChannel(int block) const
    {
        return IsLastBlock(block) ? m_StreamSoundInfo.lastBlockPaddedBytes : m_StreamSoundInfo.oneBlockBytes;
    }

    // ブロックに含まれるチャンネルごとのサンプル数を取得します。
    int GetSampleCountForBlockChannel(int block) const
    {
        return IsLastBlock(block) ? m_StreamSoundInfo.lastBlockSamples : m_StreamSoundInfo.oneBlockSamples;
    }

    const void* GetData(int block) const;
    const void* GetData(int block, int channel) const;

private:
    nn::atk::detail::StreamSoundFileReader m_Reader;
    nn::atk::detail::StreamSoundFile::StreamSoundInfo m_StreamSoundInfo;
    const void* m_pBfstmData;
    bool m_IsAvailable;
};

} } }
