﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include "Util.h"

namespace gfxutil
{


class GfxContext;

//! @brief      パネルを表します
class Panel
{
public:
    //! @brief  コンストラクタです
    explicit Panel() NN_NOEXCEPT;
    //! @brief  描画します
    void Draw(GfxContext& gfxContext) NN_NOEXCEPT;

    //! @brief  クライアント領域の左上位置を取得します
    const nn::util::Float2 GetClientPositionLeftTop() const NN_NOEXCEPT;
    //! @brief  クライアント領域の右下位置を取得します
    const nn::util::Float2 GetClientPositionRightBottom() const NN_NOEXCEPT;

    //! @brief  タイトルを設定します
    void SetTitle(const char* title) NN_NOEXCEPT;
    //! @brief  幅, 高さを設定します
    void SetSize(float width, float height) NN_NOEXCEPT;
    //! @brief  位置を設定します
    void SetPosition(float x, float y) NN_NOEXCEPT;
    //! @brief  このパネルにフォーカスがあるかどうかを設定します
    void SetFocused(bool isFocused) NN_NOEXCEPT;

    //! @brief  このパネルにフォーカスがあるかどうかを取得します
    bool IsFocused() const NN_NOEXCEPT;

private:
    //  タイトル名の最大の長さ
    static const int TitleNameLengthMax = 32;

private:
    //! @brief  クライアント領域のパラメータを設定します
    void SetClientParams() NN_NOEXCEPT;

private:
    char m_TitleName[TitleNameLengthMax];

    nn::util::Vector3fType  m_Position;
    nn::util::Float2        m_Size;
    nn::util::Vector3fType  m_ClientPosition;
    nn::util::Float2        m_ClientSize;

    bool m_IsFocused;
};


}
