﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/atk.h>
#include <nn/spy.h>
#include <nn/spy/atk/spy_AtkSpyModule.h>
#include "AtkPlayerBuildConfig.h"


#if defined( ATKPLAYER_BUILD_CONFIG_ENABLE_PROFILE_WITH_SPY )

//! @brief  spy ツールを用いたプロファイリングを行います
class SpyToolProfiler
{
public:
    //! @brief  必要なバッファサイズを計算します
    size_t GetRequiredMemorySize() NN_NOEXCEPT;
    //! @brief  初期化します
    void Initialize(void* buffer, size_t bufferSize) NN_NOEXCEPT;
    //! @brief  終了処理をします
    void Finalize() NN_NOEXCEPT;
    //! @brief  更新処理をします
    void Update(nn::atk::SoundArchivePlayer& soundArchivePlayer) NN_NOEXCEPT;

private:
    nn::spy::SpyController m_SpyController;
    nn::spy::atk::AtkSpyModule m_AtkSpyModule;
    void*  m_WaveBuffer;
    size_t m_WaveBufferSize;
};

#else

//  spy ツールを使用しないときのダミー
class SpyToolProfiler
{
public:
    //! @brief  必要なバッファサイズを計算します
    size_t GetRequiredMemorySize() NN_NOEXCEPT;
    //! @brief  初期化します
    void Initialize(void* buffer, size_t bufferSize) NN_NOEXCEPT;
    //! @brief  終了処理をします
    void Finalize() NN_NOEXCEPT;
    //! @brief  更新処理をします
    void Update(nn::atk::SoundArchivePlayer& soundArchivePlayer) NN_NOEXCEPT;
};

#endif
