﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "gfxutil/Panel.h"
#include "gfxutil/Label.h"
#include "HidPad.h"
#include "SelectItemList.h"


//! @brief  SoundSystem のパネルです
class SoundSystemPanel
{
public:
    //! @brief  初期化します
    void Initialize(float positionX, float positionY, float sizeX, float sizeY) NN_NOEXCEPT;
    //! @brief  入力による更新を行います
    void UpdateByHid(const HidPad& hidPad) NN_NOEXCEPT;
    //! @brief  描画します
    void Draw(gfxutil::GfxContext& gfxContext) NN_NOEXCEPT;

    //! @brief  フォーカスを設定します
    void SetFocused(bool isFocused) NN_NOEXCEPT;

private:
    enum ItemType
    {
        ItemType_OutputMode,
        ItemType_Max
    };

private:
    gfxutil::Panel m_Panel;
    SelectItemList<ItemType_Max> m_ItemList;

    int m_OutputMode;
};
