﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/fs.h>

//! @brief  AtkPlayer の操作ログを扱います
class FlightRecorder
{
public:
    //! @brief  ログを書き出します
    void WriteLog(const char* str, ...) NN_NOEXCEPT;

    //! @brief  初期化します
    void Initialize(bool isEnabledFlightRecorder, const char* logName) NN_NOEXCEPT;
    //! @brief  終了処理します
    void Finalize() NN_NOEXCEPT;
    //! @brief  インスタンスを取得します
    static FlightRecorder& GetInstance() NN_NOEXCEPT;

private:
    bool m_IsEnabled;

    nn::fs::FileHandle m_LogFile;
    int64_t m_LogFileWriteIndex;
};
