﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

const int COMBINE_DATA_BIT_LENGTH = 8;
const int COMBINE_MODE_BIT_LENGTH = 5;
const int COMBINE_MODE_MASK = (1 << COMBINE_MODE_BIT_LENGTH) - 1;
const int SELECT_ALPHA_MAX_MASK1 = 1 << 7;
const int SELECT_ALPHA_MAX_MASK2 = 1 << (7 + COMBINE_DATA_BIT_LENGTH);

//---------------------------------------------------------------------------
vec4 InterporateQuadColor(const in mat4 colors, const in vec4 coord)
{
    vec4 colorL = colors[0] * coord.w + colors[2] * coord.y;
    vec4 colorR = colors[1] * coord.w + colors[3] * coord.y;
    return colorL * coord.z + colorR * coord.x;
}

//---------------------------------------------------------------------------
void CombineColor(
    const in vec4 textureColor,
    const in bool selectAlphaMax,
    inout vec4 color)
{
    // マルチテクスチャの種類を増やす場合は、\Programs\Iris\Include\nn\ui2d\ui2d_Types.h の TevMode と同期して修正します。
    // NW_TEXTURE_COMBINE_TYPE の値は、\Programs\Iris\Sources\Resources\Ui2dShaders\ui2d_BuildinShaderVariation.xml と同期して修正します。

    // TevMode_Replace
    #if NW_TEXTURE_COMBINE_TYPE == 0
    color.rgb = textureColor.rgb * textureColor.a + color.rgb * (1 - textureColor.a);
    #endif

    // TevMode_Modulate
    #if NW_TEXTURE_COMBINE_TYPE == 1
    color.rgb = color.rgb * textureColor.rgb;
    #endif

    // TevMode_Add
    #if NW_TEXTURE_COMBINE_TYPE == 2
    color.rgb = color.rgb + textureColor.rgb * textureColor.a;
    #endif

    // TevMode_Subtract
    #if NW_TEXTURE_COMBINE_TYPE == 3
    color.rgb = color.rgb - textureColor.rgb * textureColor.a;
    #endif

    // TevMode_AddSigned
    #if NW_TEXTURE_COMBINE_TYPE == 5
    vec3 c0 = color.rgb;
    vec3 c1 = textureColor.rgb * textureColor.a;
    color.rgb = (1 - c1.rgb) * c0.rgb + (1 - c0.rgb) * c1.rgb;
    #endif

    // TevMode_AddMultiply
    #if NW_TEXTURE_COMBINE_TYPE == 4
    color.rgb = color.rgb / (1.00001 - textureColor.rgb * textureColor.a);
    color.rgb = clamp(color.rgb, 0, 1);
    #endif

    // TevMode_MultiplyAdd
    #if NW_TEXTURE_COMBINE_TYPE == 7
    color.rgb = 1 - (1.00001 - color.rgb) / textureColor.rgb;
    color.rgb = clamp(color.rgb, 0, 1);
    #endif

    // TevMode_Overlay
    #if NW_TEXTURE_COMBINE_TYPE == 8
    vec3 multi = 2.0 * color.rgb * textureColor.rgb;
    vec3 screen = 1.0 - 2.0 * (1.0 - color.rgb) * (1.0 - textureColor.rgb);
    color.rgb = mix(screen, multi, lessThan(color.rgb, vec3(0.5)));
    #endif

    // TevMode_Lighten
    #if NW_TEXTURE_COMBINE_TYPE == 9
    color.r = max(color.r, textureColor.r);
    color.g = max(color.g, textureColor.g);
    color.b = max(color.b, textureColor.b);
    #endif

    // TevMode_Darken
    #if NW_TEXTURE_COMBINE_TYPE == 10
    color.r = min(color.r, textureColor.r);
    color.g = min(color.g, textureColor.g);
    color.b = min(color.b, textureColor.b);
    #endif

    color.a = selectAlphaMax ? max(color.a, textureColor.a) : min(color.a, textureColor.a);
}

//---------------------------------------------------------------------------
void CombineColor2(
    const in vec4 textureColor,
    const in bool selectAlphaMax,
    inout vec4 color)
{
    #if NW_TEXTURE_COMBINE_TYPE2 == 0
    color.rgb = textureColor.rgb * textureColor.a + color.rgb * (1 - textureColor.a);
    #endif

    #if NW_TEXTURE_COMBINE_TYPE2 == 1
    color.rgb = color.rgb * textureColor.rgb;
    #endif

    #if NW_TEXTURE_COMBINE_TYPE2 == 2
    color.rgb = color.rgb + textureColor.rgb * textureColor.a;
    #endif

    #if NW_TEXTURE_COMBINE_TYPE2 == 5
    color.rgb = color.rgb - textureColor.rgb * textureColor.a;
    #endif

    #if NW_TEXTURE_COMBINE_TYPE2 == 8
    vec3 multi = 2.0 * color.rgb * textureColor.rgb;
    vec3 screen = 1.0 - 2.0 * (1.0 - color.rgb) * (1.0 - textureColor.rgb);
    color.rgb = mix(screen, multi, lessThan(color.rgb, vec3(0.5)));
    #endif

    #if NW_TEXTURE_COMBINE_TYPE2 == 3
    vec3 c0 = color.rgb;
    vec3 c1 = textureColor.rgb * textureColor.a;
    color.rgb = (1 - c1.rgb) * c0.rgb + (1 - c0.rgb) * c1.rgb;
    #endif

    #if NW_TEXTURE_COMBINE_TYPE2 == 4
    color.rgb = color.rgb / (1.00001 - textureColor.rgb * textureColor.a);
    color.rgb = clamp(color.rgb, 0, 1);
    #endif

    #if NW_TEXTURE_COMBINE_TYPE2 == 7
    color.rgb = 1 - (1.00001 - color.rgb) / textureColor.rgb;
    color.rgb = clamp(color.rgb, 0, 1);
    #endif

    #if NW_TEXTURE_COMBINE_TYPE2 == 9
    color.r = max(color.r, textureColor.r);
    color.g = max(color.g, textureColor.g);
    color.b = max(color.b, textureColor.b);
    #endif

    #if NW_TEXTURE_COMBINE_TYPE2 == 10
    color.r = min(color.r, textureColor.r);
    color.g = min(color.g, textureColor.g);
    color.b = min(color.b, textureColor.b);
    #endif

    color.a = selectAlphaMax ? max(color.a, textureColor.a) : min(color.a, textureColor.a);
}

//---------------------------------------------------------------------------
vec4 SampleColorWithSingleIndirectTexture(
    const in vec4 indirectColor,
    const in sampler2D texSampler,
    const in vec2 texCoord)
{
    float alpha = indirectColor.a;

    vec2 indirect;
    indirect.x = dot(vec4(indirectColor.xyz, 1.0), uIndirectMtx0);
    indirect.y = dot(vec4(indirectColor.xyz, 1.0), uIndirectMtx1);

    vec4 color = texture(texSampler, texCoord + indirect);
    color.a = min(color.a, alpha);

    return color;
}

//---------------------------------------------------------------------------
vec4 SampleColorWithDoubleIndirectTexture(
    const in vec4 indirectColor0,
    const in vec4 indirectColor1,
    const in sampler2D texSampler,
    const in vec2 texCoord)
{
    float alpha = indirectColor0.a * indirectColor1.a;
    vec4 color0;
    color0.rgb = (indirectColor0.rgb - 0.5) * 2;
    color0.w = 1;
    vec4 color1;
    color1.rgb = (indirectColor1.rgb - 0.5) * 2;
    color1.w = 1;

    CombineColor2(color1, true, color0);

    vec2 indirect;
    indirect.x = dot(color0.xy, uIndirectMtx0.xy);
    indirect.y = dot(color0.xy, uIndirectMtx1.xy);
    indirect *= 0.5;

    vec4 color = texture(texSampler, texCoord + indirect);
    color.a = min(color.a, alpha);

    return color;
}
