﻿/*---------------------------------------------------------------------------*
  Project:  NintendoWare

  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

uniform sampler2D uTexture3;

//------------------------------------------------------------------------------
// 互換性保持
//------------------------------------------------------------------------------
// nw Definitions
#define OUTPUT_COLOR o_Color

#define nwOutputAlbedoColor o_Color
#define nwAlbedoTexture0 uTexture0
#define nwAlbedoTexture1 uTexture1
#define nwAlbedoTexture2 uTexture2
#define nwAlbedoTexture3 uTexture0

#define nwTextureCoord0 vec2(vTexCoord[0].s, vTexCoord[0].t)
#define nwTextureCoord1 vec2(vTexCoord[1].s, vTexCoord[1].t)
#define nwTextureCoord2 vec2(vTexCoord[2].s, vTexCoord[2].t)
#define nwTextureCoord3 vec2(vTexCoord[0].s, vTexCoord[0].t)

#define nwConstantColor0 uConstantColor[0]
#define nwConstantColor1 uConstantColor[1]
#define nwConstantColor2 uConstantColor[2]
#define nwConstantColor3 uConstantColor[3]
#define nwConstantColor4 uConstantColor[4]
#define nwConstantColor5 uConstantColor[5]
#define nwConstantColor6 uConstantColor[6]

#define paneSize vec2(paneWidth, paneHeight)

#define sysFrameBufferTexture uTexture3

#define sysFragCoordVary  vTexCoord[0]
#define sysFragCoordVary1 vTexCoord[1]
#define sysFragCoordVary2 vTexCoord[2]

#define sysTextureSize0 uTextureSize[0]
#define sysTextureSize1 uTextureSize[1]
#define sysTextureSize2 uTextureSize[2]

#define _TEXTURE_ORIGIN_LOWER_LEFT              1   // フレームバッファテクスチャ原点は左下

float CalcAlphaProcess(float alpha)
{
    return alpha;
}

void FinalAdjustmentFragmentColor()
{
    // 最適化により uTexture がシンボル除去されるのを防止します。 uPadding1_0 は常に '0.0f' がランタイムより渡されます。
    if (fixedZero != 0.0f)
    {
        // 最適化防止の為、このコードが行われる事はありません。
        float colorAlpha =
            texture(uTexture0, vTexCoord[0].st).a +
            texture(uTexture1, vTexCoord[1].st).a +
            texture(uTexture2, vTexCoord[2].st).a;
        o_Color.a += colorAlpha * fixedZero;
    }


}

