﻿/*---------------------------------------------------------------------------*
  Copyright (C)Nintendo/HAL Laboratory, Inc.  All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *---------------------------------------------------------------------------*/

#if NEED_330_EXTENSION
#extension GL_ARB_separate_shader_objects : enable
#extension GL_ARB_enhanced_layouts : enable
#endif

#ifdef NN_GFX_VULKAN
#define FONT_BINDING_LAYOUT(n) layout( binding = n )
#define FONT_LOCATION_LAYOUT(n) layout( location = n )
#define FONT_BINDING(n) binding = n,
#else
#define FONT_BINDING_LAYOUT(n)
#define FONT_LOCATION_LAYOUT(n)
#define FONT_BINDING(n)
#endif

FONT_BINDING_LAYOUT(2) uniform sampler2DArray uTextureSrc;
layout(FONT_BINDING(0) std140) uniform ShaderParam
{
    mat4 uUser;
    vec4 uInterpolateWidth;
    vec4 uInterpolateOffset;
    vec4 uShadowInterpolateWidth;
    vec4 uShadowInterpolateOffset;
};
layout(FONT_BINDING(3) std140) uniform ShaderParamBlackWhiteInterpolation
{
    int uBlackWhiteInterpolationFlags;
};

layout(location = 0) in vec4 vColor;
layout(location = 1) in vec4 vTexCoord;

layout(location = 0) out vec4 oColor;

void main(void)
{
    vec4 textureColor = texture(uTextureSrc, vTexCoord.xyz);
    if(textureColor.a <= 0.0)
    {
        // 以降でアルファ値が増加することは無いので、早期に discard します。
        discard;
    }

#if NW_BDR
    if (textureColor.a < 0.54)
    {
        textureColor.rgb = vec3(0.0);
        textureColor.a *= 2.0;
    }
    else
    {
        textureColor.rgb = vec3((textureColor.a - 0.5) * 2.0);
        textureColor.a = 1.0;
    }
#endif
#if NW_IVB
    if (textureColor.a < 0.54)
    {
        textureColor.a *= 0.0;
    }
    else
    {
        textureColor.a = (textureColor.a - 0.5) * 2.0;
    }
#endif

    if (0.0 < vColor.a)
    {
        vec4 width = uInterpolateWidth;
        vec4 offset = uInterpolateOffset;

        if (uBlackWhiteInterpolationFlags == 0)
        {
            // 白黒補完のカラーは使用しないが、アルファ値は使用する。
            offset = vec4(0, 0, 0, 0);
            width.rgb = vec3(1, 1, 1);
        }

#if NW_IVB
        oColor.rgb = (offset.rgb + width.rgb) * vColor.rgb;
#else
        oColor.rgb = (offset.rgb + width.rgb * textureColor.rgb) * vColor.rgb;
#endif
        oColor.a = (width.a * textureColor.a) * vColor.a;
    }
    else
    {
        // for shadow
#if NW_IVB
        oColor.rgb = (uShadowInterpolateOffset.rgb + uShadowInterpolateWidth.rgb) * vColor.rgb;
#else
        oColor.rgb = (uShadowInterpolateOffset.rgb + uShadowInterpolateWidth.rgb * textureColor.rgb) * vColor.rgb;
#endif
        oColor.a = (uShadowInterpolateWidth.a * textureColor.a) * -vColor.a;
    }
}
