﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ui2d/ui2d_Layout.h>
#include <nn/ui2d/ui2d_ControlCreator.h>
#include <nn/ui2d/ui2d_CheckButton.h>

namespace nn
{
namespace ui2d
{

void CheckButton::Build(nn::gfx::Device* pDevice, ui2d::Layout* pLayout, const ui2d::ControlSrc& controlSrc)
{
    AnimButton::Build(pDevice, pLayout, controlSrc );

    // Checkアニメーションの取得
    m_pCheckAnimator = pLayout->CreateGroupAnimatorAuto(pDevice, controlSrc.FindFunctionalAnimName("Check"), true);
    NN_SDK_ASSERT(m_pCheckAnimator, "cannot create CheckAnimator[%s] for Layout[%s]", controlSrc.FindFunctionalAnimName("Check"), pLayout->GetName());
    m_pCheckAnimator->StopAtStartFrame();
}

void CheckButton::ForceSetChecked(bool checked)
{
    m_IsChecked = checked;
    if (m_pCheckAnimator) {
        if (checked) {
            m_pCheckAnimator->StopAtEndFrame();
        } else {
            m_pCheckAnimator->StopAtStartFrame();
        }
    }
}

void CheckButton::FinishDown()
{
    // 互換性のために、いったんSTATE_DOWN_IDLEにします。
    ChangeState(State_DownIdle);
    // NormalButtonと同様に、Downアニメーションが終わった後、ON状態にします。
    ChangeState(State_OnIdle);
}

void CheckButton::StartDown()
{
    AnimButton::StartDown();

    if (m_pCheckAnimator) {
        m_pCheckAnimator->Play(ui2d::Animator::PlayType_OneShot, m_IsChecked ? -1.f : 1.f);
    }
    m_IsChecked = ! m_IsChecked;
}

bool CheckButton::UpdateDown()
{
    bool retval = AnimButton::UpdateDown();

    if (m_pCheckAnimator) {
        if (m_IsChecked) {
            retval = (GetDownAnimator()->IsMaxFrame() && m_pCheckAnimator->IsMaxFrame());
        } else {
            retval = (GetDownAnimator()->IsMaxFrame() && m_pCheckAnimator->IsMinFrame());
        }
    }

    return retval;
}

} // namespace nn::ui2d
} // namespace nn
