﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../../precompiled.h"

#include <nn/spy/detail/fnd/string/spyfnd_String.h>

namespace nn {
namespace spy {
namespace detail {
namespace fnd {

//----------------------------------------------------------
void
String::Copy(char* buffer, int bufferLength, const char* src) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(buffer);
    NN_SDK_ASSERT_NOT_NULL(src);
    NN_SDK_ASSERT_GREATER_EQUAL(bufferLength, 0);

    if(bufferLength == 0)
    {
        return;
    }

    const char* srcCurrent = src;
    char*       dstCurrent = buffer;
    char*       dstEnd = buffer + bufferLength;

    while(dstCurrent + 1 != dstEnd)
    {
        // コピーバッファ競合チェック
        NN_SDK_ASSERT(srcCurrent < buffer || dstEnd <= srcCurrent);

        if(*srcCurrent == '\0')
        {
            break;
        }

        *dstCurrent = *srcCurrent;

        ++srcCurrent;
        ++dstCurrent;
    }

    // 終端文字を付加する
    *dstCurrent = '\0';
}

} // namespace nn::spy::detail::fnd
} // namespace nn::spy::detail
} // namespace nn::spy
} // namespace nn
