﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ige/ige_EditService.h>
#include <nn/ige/ige_ValueNode.h>

#include "detail/ige_Allocator.h"
#include "detail/messages/ige_ValueMessage.h"
#include "detail/messages/ige_ValueRequestMessage.h"
#include "detail/messages/ige_NodeMessage.h"

namespace nn { namespace ige {

void ValueNodeBase::OnMessageReceived(const detail::NodeTargetMessage& data) NN_NOEXCEPT
{
    auto type = data.GetType();

    if (detail::ValueMessage::IsTarget(type))
    {
        Deserialize(static_cast<const detail::ValueMessage&>(data).GetData());
    }
    else if (detail::ValueRequestMessage::IsTarget(type))
    {
        PushValue();
    }
    else
    {
        Node::OnMessageReceived(data);
    }
}

void ValueNodeBase::PushValue() NN_NOEXCEPT
{
    BufferWriter writer(GetService()->GetAllocator().GetResource());
    Serialize(&writer);
    detail::ValueMessage message(GetId(), writer.GetBuffer());
    GetService()->SendMessage(message);
}

void ValueNodeBase::PushInfo() NN_NOEXCEPT
{
    BufferWriter writer(GetService()->GetAllocator().GetResource());
    WriteMetadata(&writer);

    detail::NodeMessage nodeInfo(
        GetId(),
        GetParentId(),
        GetNodeType(),
        GetTypeName(),
        writer.GetBuffer());

    GetService()->SendMessage(nodeInfo);

    // 現在の値も一緒に送ってあげる
    PushValue();

    if (IsEnabledAutoNotify())
    {
        PushChildInfo();
    }
}

}} // namespace nn::ige
