﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "ige_Message.h"

namespace nn { namespace ige { namespace detail {

class ValueMessage : public NodeTargetMessage
{
public:
    ValueMessage(NodeIdType id, const BufferView& data) NN_NOEXCEPT
        : NodeTargetMessage(id)
        , m_Data(data)
    {
    }

    virtual MessageType GetType() const NN_NOEXCEPT NN_OVERRIDE
    {
        return MessageType_Value;
    }

    const BufferView& GetData() const
    {
        return m_Data;
    }

    static bool IsTarget(MessageType type) NN_NOEXCEPT
    {
        return type == MessageType_Value;
    }

    static bool IsTarget(const BufferView& buffer) NN_NOEXCEPT
    {
        return IsTarget(GetMessageType(buffer));
    }

    static ValueMessage Read(const BufferView& buffer) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES(IsTarget(buffer));

        BufferReader reader(buffer);
        reader.ReadInt32(); // for MessageType

        auto id = static_cast<NodeIdType>(reader.ReadUInt32());
        auto data = reader.ReadBuffer();

        return ValueMessage(id, data);
    }

protected:
    virtual void WritePacket(BufferWriter* pWriter) const NN_NOEXCEPT NN_OVERRIDE
    {
        pWriter->Write(m_Data);
    }

private:
    BufferView m_Data;
};

}}} // namespace nn::ige::detail
