﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "ige_Message.h"

namespace nn { namespace ige { namespace detail {

class RemoveNodeMessage : public SystemMessage
{
public:
    explicit RemoveNodeMessage(NodeIdType id) NN_NOEXCEPT
        : m_Id(id)
    {
    }

    virtual MessageType GetType() const NN_NOEXCEPT NN_OVERRIDE
    {
        return MessageType_RemoveNode;
    }

    static bool IsTarget(MessageType type) NN_NOEXCEPT
    {
        return type == MessageType_RemoveNode;
    }

    static bool IsTarget(const BufferView& buffer) NN_NOEXCEPT
    {
        return IsTarget(GetMessageType(buffer));
    }

protected:
    virtual void WritePacket(BufferWriter* pWriter) const NN_NOEXCEPT NN_OVERRIDE
    {
        pWriter->Write(static_cast<uint32_t>(m_Id));
    }

private:
    NodeIdType m_Id;
};

}}} // namespace nn::ige::detail
