﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "g3d_FixedSizeArray.h"
#include "g3d_SynchronizedObject.h"
#include "g3d_ScopedLock.h"

namespace nn { namespace g3d { namespace viewer { namespace detail {

template <typename T>
class SynchronizedFixedSizeArray : public SynchronizedObject
{
public:
    SynchronizedFixedSizeArray() NN_NOEXCEPT
    {
    }

    void SetArrayBuffer(void* arrayBuffer, int arrayCount)
    {
        ScopedLock scopedLock(GetMutex());
        m_FixedSizeArray.SetArrayBuffer(arrayBuffer, arrayCount);
    }

    T* GetArrayBufferPtr() NN_NOEXCEPT
    {
        ScopedLock scopedLock(GetMutex());
        return m_FixedSizeArray.GetArrayBufferPtr();
    }
    const T* GetArrayBufferPtr() const NN_NOEXCEPT
    {
        ScopedLock scopedLock(*const_cast<nn::os::Mutex*>(&GetMutex()));
        return m_FixedSizeArray.GetArrayBufferPtr();
    }

    void* GetBufferPtr() NN_NOEXCEPT
    {
        ScopedLock scopedLock(GetMutex());
        return m_FixedSizeArray.GetBufferPtr();
    }
    const void* GetBufferPtr() const NN_NOEXCEPT
    {
        ScopedLock scopedLock(*const_cast<nn::os::Mutex*>(&GetMutex()));
        return m_FixedSizeArray.GetBufferPtr();
    }

    int GetCount() const NN_NOEXCEPT
    {
        ScopedLock scopedLock(*const_cast<nn::os::Mutex*>(&GetMutex()));
        return m_FixedSizeArray.GetCount();
    }

    T* UnsafeAt(int index) NN_NOEXCEPT
    {
        ScopedLock scopedLock(GetMutex());
        return m_FixedSizeArray.UnsafeAt(index);
    }

    const T* UnsafeAt(int index) const NN_NOEXCEPT
    {
        ScopedLock scopedLock(*const_cast<nn::os::Mutex*>(&GetMutex()));
        return m_FixedSizeArray.UnsafeAt(index);
    }

    void Clear() NN_NOEXCEPT
    {
        ScopedLock scopedLock(GetMutex());
        m_FixedSizeArray.Clear();
    }

private:
    FixedSizeArray<T> m_FixedSizeArray;
};

}}}} // namespace nn::g3d::viewer::detail
