﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/g3d/viewer/g3d_ViewerDefine.h>



#include "../g3d_ViewerDetailDefine.h"
#include "../g3d_Allocator.h"

namespace nn { namespace g3d { namespace viewer {

namespace detail {
    class ScopedAllocator
    {
    public:
        ScopedAllocator(nn::g3d::viewer::detail::IAllocator& allocator, size_t allocateSize, uintptr_t alignment, AllocateType type) NN_NOEXCEPT
            : m_pAllocator(&allocator)
            , m_pBuffer(nullptr)
            , m_AllocatedSize(allocateSize)
        {
            if (allocateSize == 0)
            {
                return;
            }

            m_pBuffer = m_pAllocator->Allocate(allocateSize, alignment, type);
            NN_G3D_VIEWER_ASSERT_NOT_NULL_DETAIL(m_pBuffer, "insufficient memory");
        }
        ~ScopedAllocator() NN_NOEXCEPT
        {
            if (m_pBuffer)
            {
                m_pAllocator->Free(m_pBuffer);
            }

            m_pAllocator = nullptr;
            m_pBuffer = nullptr;
        }

        void* GetAllocatedBuffer() NN_NOEXCEPT
        {
            return m_pBuffer;
        }

        const void* GetAllocatedBuffer() const NN_NOEXCEPT
        {
            return m_pBuffer;
        }

        template<typename T>
        T* GetAllocatedBuffer() NN_NOEXCEPT
        {
            return static_cast<T*>(m_pBuffer);
        }

        template<typename T>
        const T* GetAllocatedBuffer() const NN_NOEXCEPT
        {
            return static_cast<const T*>(m_pBuffer);
        }

        size_t GetAllocatedSize() const NN_NOEXCEPT
        {
            return m_AllocatedSize;
        }

    private:
        nn::g3d::viewer::detail::IAllocator* m_pAllocator;
        void* m_pBuffer;
        size_t m_AllocatedSize;
    };
}
}}}

