﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../g3d_ViewerDetailDefine.h"



namespace nn { namespace g3d { namespace viewer {

namespace detail {

template <typename T>
class FixedSizeArray
{
public:
    explicit FixedSizeArray() NN_NOEXCEPT
        : m_pArray(nullptr)
        , m_ArraySize(0)
    {}

    static size_t CalculateBufferSize(int arrayCount);

    void SetArrayBuffer(void* arrayBuffer, int arrayCount)
    {
        NN_G3D_VIEWER_ASSERT_NOT_NULL(arrayBuffer);
        NN_G3D_VIEWER_ASSERT(arrayCount > 0);

        m_pArray = static_cast<T*>(arrayBuffer);
        m_ArraySize = arrayCount;
    }

    T* GetArrayBufferPtr() NN_NOEXCEPT
    {
        return m_pArray;
    }
    const T* GetArrayBufferPtr() const NN_NOEXCEPT
    {
        return m_pArray;
    }

    void* GetBufferPtr() NN_NOEXCEPT
    {
        return static_cast<void*>(m_pArray);
    }
    const void* GetBufferPtr() const NN_NOEXCEPT
    {
        return reinterpret_cast<void*>(m_pArray);
    }

    int GetCount() const NN_NOEXCEPT
    {
        return m_ArraySize;
    }

    T* UnsafeAt(int index) NN_NOEXCEPT
    {
        return &m_pArray[index];
    }

    const T* UnsafeAt(int index) const NN_NOEXCEPT
    {
        return &m_pArray[index];
    }

    void Clear() NN_NOEXCEPT
    {
        m_pArray = nullptr;
        m_ArraySize = 0;
    }

private:
    T* m_pArray;
    int m_ArraySize;
};

template <typename T>
size_t FixedSizeArray<T>::CalculateBufferSize(int arrayCount)
{
    NN_G3D_VIEWER_ASSERT(arrayCount > 0);
    return sizeof(T) * arrayCount;
}

} // namespace detail

}}}


