﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "g3d_BufferSwitcher.h"
#include "g3d_EditWorkBuffer.h"

namespace nn { namespace g3d { namespace viewer { namespace detail {

class EditWorkBufferSwitcher
{
public:
    EditWorkBufferSwitcher(int bufferingCount, Allocator* pAllocator) NN_NOEXCEPT
        : m_BufferSwitcher(pAllocator)
        , m_pAllocator(pAllocator)
    {
        for (int poolManagerIndex = 0; poolManagerIndex < bufferingCount; ++poolManagerIndex)
        {
            void* buffer = m_pAllocator->Allocate(sizeof(EditWorkBuffer), nn::DefaultAlignment, AllocateType_Other);
            NN_G3D_VIEWER_ASSERT_NOT_NULL(buffer);
            m_BufferSwitcher.AppendBuffer(new (buffer) EditWorkBuffer(pAllocator, AllocateType_DynamicBuffer));
        }
    }

    virtual ~EditWorkBufferSwitcher() NN_NOEXCEPT
    {
        for (int bufferIndex = 0, bufferCount = m_BufferSwitcher.GetBufferCount(); bufferIndex < bufferCount; ++bufferIndex)
        {
            EditWorkBuffer* buffer = m_BufferSwitcher.GetBuffer(bufferIndex);
            buffer->~EditWorkBuffer();
            m_pAllocator->Free(buffer);
        }
    }

    void* GetCurrentBuffer() NN_NOEXCEPT
    {
        return m_BufferSwitcher.GetCurrentBuffer()->GetWorkBufferPtr();
    }

    template<typename T>
    T* GetCurrentBuffer() NN_NOEXCEPT
    {
        return reinterpret_cast<T*>(GetCurrentBuffer());
    }

    template<typename T>
    T* GetBuffer(int index) NN_NOEXCEPT
    {
        return reinterpret_cast<T*>(m_BufferSwitcher.GetBuffer(index)->GetWorkBufferPtr());
    }

    size_t GetCurrentBufferSize() const NN_NOEXCEPT
    {
        return m_BufferSwitcher.GetCurrentBuffer()->GetSize();
    }

    size_t GetBufferSize(int bufferIndex) const NN_NOEXCEPT
    {
        return m_BufferSwitcher.GetBuffer(bufferIndex)->GetSize();
    }

    int GetBufferCount() const NN_NOEXCEPT
    {
        return m_BufferSwitcher.GetBufferCount();
    }

    void SwitchCurrentBuffer() NN_NOEXCEPT
    {
        m_BufferSwitcher.SwitchCurrentBuffer();
    }

    bool ResizeCurrentBuffer(size_t size) NN_NOEXCEPT
    {
        return m_BufferSwitcher.GetCurrentBuffer()->Resize(size);
    }

    EditWorkBuffer* GetEditWorkBuffer(int bufferIndex) NN_NOEXCEPT
    {
        return m_BufferSwitcher.GetBuffer(bufferIndex);
    }

private:
    BufferSwitcher<EditWorkBuffer> m_BufferSwitcher;
    Allocator* m_pAllocator;
};

}}}} // namespace nn::g3d::viewer::detail
