﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../g3d_ViewerDetailDefine.h"
#include "../g3d_Allocator.h"
#include "g3d_ScopedAllocator.h"
#include <nn/g3d/detail/g3d_Inlines.h>
#include "g3d_DynamicArray.h"

namespace nn { namespace g3d { namespace viewer { namespace detail {

template<typename T>
class DynamicPtrArray
{
public:
    typedef int (*CompareCallback)(const T* a, const T* b);

    explicit DynamicPtrArray(nn::g3d::viewer::detail::Allocator* pAllocator, size_t alignment) NN_NOEXCEPT
        : m_Impl(pAllocator, alignment, nullptr)
    {
    }

    ~DynamicPtrArray() NN_NOEXCEPT
    {
    }

    int GetCount() const NN_NOEXCEPT
    {
        return m_Impl.GetCount();
    }

    void Clear() NN_NOEXCEPT
    {
        m_Impl.Clear();
    }

    void Destroy() NN_NOEXCEPT
    {
        m_Impl.Destroy();
    }

    void EraseByIndex(int index) NN_NOEXCEPT
    {
        m_Impl.EraseByIndex(index);
    }

    T* At(int index) const NN_NOEXCEPT
    {
        return m_Impl[index];
    }

    T* UnsafeAt(int index) const NN_NOEXCEPT
    {
        return m_Impl[index];
    }

    T* Front() const NN_NOEXCEPT
    {
        return m_Impl.Front();
    }

    T* Back() const NN_NOEXCEPT
    {
        return m_Impl.Back();
    }

    bool PushBack(T* pElem) NN_NOEXCEPT
    {
        return m_Impl.PushBack(pElem);
    }

    T* PopBack() NN_NOEXCEPT
    {
        return m_Impl.PopBack();
    }

    template<typename TKey>
    T* Find(const TKey* pKey, int(*compareCallback)(const T* pValue, const TKey* pKey)) const NN_NOEXCEPT
    {
        for (int index = 0; index < m_Impl.GetCount(); ++index)
        {
            if (compareCallback(m_Impl[index], pKey) == 0)
            {
                return m_Impl[index];
            }
        }
        return nullptr;
    }

    template<typename TKey>
    int Search(const TKey* pKey, int(*compareCallback)(const T* pValue, const TKey* pKey)) const NN_NOEXCEPT
    {
        for (int index = 0; index < m_Impl.GetCount(); ++index)
        {
            if (compareCallback(m_Impl[index], pKey) == 0)
            {
                return index;
            }
        }
        return -1;
    }

    int IndexOf(const T* pTarget) const NN_NOEXCEPT
    {
        for (int index = 0; index < m_Impl.GetCount(); ++index)
        {
            if (m_Impl[index] == pTarget)
            {
                return index;
            }
        }

        return -1;
    }

    bool Resize(size_t size) NN_NOEXCEPT
    {
        return m_Impl.Resize(size);
    }

    Iter<T*> Begin() NN_NOEXCEPT
    {
        return m_Impl.Begin();
    }

    Iter<T*> End() NN_NOEXCEPT
    {
        return m_Impl.End();
    }

    Iter<T*> Erase(const Iter<T*>& iter) NN_NOEXCEPT
    {
        return m_Impl.Erase(iter);
    }

    T* operator[] (int index) NN_NOEXCEPT
    {
        return m_Impl[index];
    }

    const T* operator[] (int index) const NN_NOEXCEPT
    {
        return m_Impl[index];
    }

private:
    DynamicArray<T*> m_Impl;
};

}}}} // namespace nn::g3d::viewer::detail
