﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../g3d_ViewerDetailDefine.h"
#include "g3d_IViewerCommand.h"
#include "g3d_CommandTypes.h"
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>
#include "../util/g3d_DynamicPtrArray.h"
#include "../model/g3d_EditRenderInfo.h"

namespace nn { namespace g3d { namespace viewer { namespace detail {
    class CommandMonitor;
    class SendRenderInfoDefinitionCommand : public IViewerCommand
    {
    public:
        SendRenderInfoDefinitionCommand(
            Allocator* pAllocator,
            CommandMonitor* pMonitor) NN_NOEXCEPT;
        ~SendRenderInfoDefinitionCommand() NN_NOEXCEPT;

        virtual int Type() const NN_NOEXCEPT
        {
            return CommandType_SendRenderInfoDefinition;
        }

        virtual CommandResult Execute(EditSocketBase* pSocket) NN_NOEXCEPT;

        EditRenderInfo* NewEditRenderInfo(ViewerKeyType modelKey, int materialIndex) NN_NOEXCEPT;

        void DeleteEditRenderInfo(EditRenderInfo* pEditRenderInfo) NN_NOEXCEPT;

        EditRenderInfo* GetLastEditRenderInfo() NN_NOEXCEPT
        {
            return m_EditRenderInfos.Back();
        }

        const EditRenderInfo* GetLastEditRenderInfo() const NN_NOEXCEPT
        {
            return m_EditRenderInfos.Back();
        }

        void SetExecutable(bool isExecutable)
        {
            m_IsExecutable = isExecutable;
        }

    private:
        DynamicPtrArray<EditRenderInfo> m_EditRenderInfos;
        CommandMonitor* m_pCommandMonitor;
        Allocator* m_pAllocator;
        bool m_IsExecutable;
    };
}}}}
