﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "g3d_FileLoadedCommand.h"

#include "../g3d_EditSocket.h"
#include "../g3d_ViewerDetailDefine.h"
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>
#include "../util/g3d_ViewerUtility.h"

using namespace nn::g3d::viewer::detail;

namespace {
    bool IsAnimFileData(nn::g3d::viewer::detail::FileDataKind kind) NN_NOEXCEPT
    {
        return nn::g3d::viewer::detail::FILEDATA_SHADER_PARAM_ANIM <= kind && kind <= nn::g3d::viewer::detail::FILEDATA_MATERIAL_ANIM;
    }
}

void nn::g3d::viewer::detail::FileLoadedCommand::InitializePacket() NN_NOEXCEPT
{
    m_FileLoadedPacket.header.command = static_cast<uint32_t>(EDIT_FILE_LOADED_COMMAND_FLAG);
    m_FileLoadedPacket.header.dataSize = sizeof(FileLoadedBlock);
    m_FileLoadedPacket.header.magic = NN_G3D_EDIT_MAGIC;
    m_FileLoadedPacket.header.verWord = NN_G3D_EDIT_VERSION;

    memset(&m_FileLoadedPacket.block, 0, sizeof(m_FileLoadedPacket.block));
}

nn::g3d::viewer::detail::FileLoadedCommand::FileLoadedCommand(
    ViewerKeyType resFileKey, ViewerKeyType toolKey, FileDataKind kind) NN_NOEXCEPT
    : m_FirstLoadResFileKey(InvalidKey)
{
    InitializePacket();
    m_FileLoadedPacket.block.fileDataKind = kind;
    m_FileLoadedPacket.block.toolKey = toolKey;
    m_FileLoadedPacket.block.resFileKey = resFileKey;
}

nn::g3d::viewer::detail::FileLoadedCommand::FileLoadedCommand(
    ViewerKeyType resModelKey, ViewerKeyType resFileKey, ViewerKeyType firstLoadedResFileKey, ViewerKeyType toolKey) NN_NOEXCEPT
    : m_FirstLoadResFileKey(firstLoadedResFileKey)
{
    InitializePacket();
    m_FileLoadedPacket.block.fileDataKind = FILEDATA_MODEL;
    m_FileLoadedPacket.block.toolKey = toolKey;
    m_FileLoadedPacket.block.resFileKey = resFileKey;
    m_FileLoadedPacket.block.resModelKey = resModelKey;
}

nn::g3d::viewer::detail::FileLoadedCommand::FileLoadedCommand(
    ViewerKeyType resFileKey, ViewerKeyType newResFileKey, ViewerKeyType toolKey, FileDataKind kind) NN_NOEXCEPT
    : m_FirstLoadResFileKey(InvalidKey)
{
    InitializePacket();
    m_FileLoadedPacket.header.command = static_cast<uint32_t>(EDIT_FILE_RELOADED_COMMAND_FLAG);
    m_FileLoadedPacket.block.fileDataKind = kind;
    m_FileLoadedPacket.block.toolKey = toolKey;
    m_FileLoadedPacket.block.resFileKey = resFileKey;
    m_FileLoadedPacket.block.newResFileKey = newResFileKey;
}

nn::g3d::viewer::detail::FileLoadedCommand::FileLoadedCommand(
    ViewerKeyType resModelKey, ViewerKeyType modelObjKey, ViewerKeyType resFileKey, ViewerKeyType newResFileKey, ViewerKeyType toolKey) NN_NOEXCEPT
{
    InitializePacket();
    m_FileLoadedPacket.header.command = static_cast<uint32_t>(EDIT_FILE_RELOADED_COMMAND_FLAG);
    m_FileLoadedPacket.block.fileDataKind = FILEDATA_MODEL;
    m_FileLoadedPacket.block.toolKey = toolKey;
    m_FileLoadedPacket.block.resFileKey = resFileKey;
    m_FileLoadedPacket.block.resModelKey = resModelKey;
    m_FileLoadedPacket.block.modelObjKey = modelObjKey;
    m_FileLoadedPacket.block.newResFileKey = newResFileKey;
}

nn::g3d::viewer::detail::FileLoadedCommand::~FileLoadedCommand() NN_NOEXCEPT
{
}

CommandResult nn::g3d::viewer::detail::FileLoadedCommand::Execute(EditSocketBase* pSocket) NN_NOEXCEPT
{
    if (m_FileLoadedPacket.block.fileDataKind == FILEDATA_MODEL)
    {
        bool isAttached = m_FileLoadedPacket.block.modelObjKey != 0;
        if (!isAttached)
        {
            // ロード後にユーザが遅延アタッチをした場合、まだアタッチされていないことがある
            return CommandResult_Skipped;
        }

        NN_G3D_VIEWER_ASSERT(m_FileLoadedPacket.block.modelObjKey > 0 && m_FileLoadedPacket.block.resFileKey > 0 && m_FileLoadedPacket.block.resModelKey > 0);
    }
    else if (IsAnimFileData(static_cast<FileDataKind>(m_FileLoadedPacket.block.fileDataKind))
         || (m_FileLoadedPacket.block.fileDataKind == FILEDATA_TEXTURE))
    {
        NN_G3D_VIEWER_ASSERT(m_FileLoadedPacket.block.resFileKey > 0);
    }
    else
    {
        NN_UNEXPECTED_DEFAULT;
    }

    NN_G3D_VIEWER_DEBUG_PRINT("Write FileLoadedCommand\n");
    if (!pSocket->WriteSync(&m_FileLoadedPacket, sizeof(FileLoadedPacket)))
    {
        return CommandResult_Failed;
    }

    return CommandResult_Success;
}
