﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/viewer/detail/atk_SoundArchiveEditController.h>

#ifdef NN_ATK_CONFIG_ENABLE_DEV

#include <nn/atk/atk_BasicSound.h>
#include <nn/atk/atk_SoundHandle.h>
#include <nn/atk/atk_SoundArchivePlayer.h>
#include <nn/atk/atk_SoundPlayer.h>
#include <nn/atk/fnd/io/atkfnd_FileStream.h>
#include <nn/atk/fnd/string/atkfnd_Path.h>
#include <nn/atk/viewer/detail/atk_IErrorProvider.h>
#include <nn/atk/viewer/detail/atk_SoundEditConnection.h>

namespace nn {
namespace atk {
namespace viewer {
namespace detail {

//----------------------------------------------------------
SoundArchiveEditController::SoundArchiveEditController() NN_NOEXCEPT :
m_ErrorProvider(NULL),
m_Connection(NULL),
m_ResourceManager(NULL),
m_SoundArchive(NULL),
m_SoundArchivePlayer(NULL),
m_LockCacheStatesCount(0),
m_OpenFileBuffer(NULL),
m_OpenFileBufferLength(0),
m_ItemNameBuffer(NULL),
m_ItemNameBufferLength(0),
m_MemoryUsageAtOutOfMemory(0),
m_IsItemInfosOverFlow(false),
m_IsFilesOverFlow(false),
m_IsItemInfoInfoDictionaryInvalid(false),
m_EditItemsChangedCallback(NULL),
m_EditItemsChangedCallbackParam(NULL)
{
}

//----------------------------------------------------------
atk::detail::fnd::FileStream*
SoundArchiveEditController::OpenFile(void* buffer, size_t bufferLength, const char* filePath) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(filePath);
    NN_SDK_ASSERT(*filePath != '\0');

    NN_SDK_ASSERT(IsStarted(), "SoundArchiveEditController is not started.\n");

    return m_Connection->OpenFile(buffer, bufferLength, filePath);
}

//----------------------------------------------------------
Result
SoundArchiveEditController::InitializeForPlatform(atk::detail::fnd::FrameHeap& heap) NN_NOEXCEPT
{
    (void)heap;
    return Result(ResultType_True);
}

//----------------------------------------------------------
void
SoundArchiveEditController::FinalizeForPlatform() NN_NOEXCEPT
{
}

//----------------------------------------------------------
size_t
SoundArchiveEditController::GetRequiredMemorySizeForPlatform() const NN_NOEXCEPT
{
    return 0;
}

//----------------------------------------------------------
void
    SoundArchiveEditController::SetEditItemsChangedCallback(EditItemsChangedCallback callback, uintptr_t callbackParam) NN_NOEXCEPT
{
    m_EditItemsChangedCallbackParam = callbackParam;
    m_EditItemsChangedCallback = callback;
}

//----------------------------------------------------------
atk::detail::fnd::FileStream*
SoundArchiveEditController::OpenFileForCache(void* buffer, size_t bufferLength, const char* filePath) NN_NOEXCEPT
{
    return OpenFile(buffer, bufferLength, filePath);
}

} // namespace nn::atk::viewer::detail
} // namespace nn::atk::viewer
} // namespace nn::atk
} // namespace nn

#endif // NN_ATK_CONFIG_ENABLE_DEV
