﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/viewer/detail/hio/atk_HioMessageHandler.h>

#ifdef NN_ATK_CONFIG_ENABLE_DEV

#include <nn/atk/detail/atk_Macro.h>
#include <nn/atk/viewer/detail/hio/atk_HioChannel.h>
#include <nn/atk/viewer/detail/hio/atk_HioPacketStream.h>

namespace nn {
namespace atk {
namespace viewer {
namespace detail {

//---------------------------------------------------------------------------
HioResult
HioMessageHandler::Invoke(HioPacketStream& stream) NN_NOEXCEPT
{
    if(!CanRespond(*stream.GetReadHeader()))
    {
#if !defined(NN_SDK_BUILD_RELEASE)
        NN_ATK_WARNING(
            "%s(0x%08x) is not invoked.",
            stream.GetReadHeader()->message.ToString(),
            uint32_t(stream.GetReadHeader()->message));
#endif
        return HioResult(HioResultType_False);
    }

    HioResult result = OnInvoke(stream);

    return result;
}

//---------------------------------------------------------------------------
HioResult
HioMessageHandler::OnInvoke(HioPacketStream& stream) NN_NOEXCEPT
{
    HioResult result = stream.TryReadBody();

    if(!result.IsTrue())
    {
        return result;
    }

    return OnInvokeForReadPacket(*stream.GetReadPacket(), stream);
}

//---------------------------------------------------------------------------
HioResult
HioMessageHandler::OnInvokeForReadPacket(const HioPacket& packet, HioPacketStream& stream) NN_NOEXCEPT
{
    (void)packet;
    (void)stream;

    NN_SDK_ASSERT(false, "HioMessageHandler::OnInvokeForReadPacket() is not implemented.\n");
    return HioResult(HioResultType_TargetNotImplemented);
}

} // namespace nn::atk::viewer::detail
} // namespace nn::atk::viewer
} // namespace nn::atk
} // namespace nn

#endif // NN_ATK_CONFIG_ENABLE_DEV
