﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/viewer/atk_SoundObjectController.h>

#ifdef NN_ATK_CONFIG_ENABLE_DEV

#if !defined(NN_SDK_BUILD_RELEASE)
//#define NN_ATK_ENABLE_ERROR_DEBUG
#endif

namespace nn {
namespace atk {
namespace viewer {

NN_DEFINE_STATIC_CONSTANT( const uint32_t SoundObjectController::SoundControllerCount );

//----------------------------------------------------------
SoundObjectController::SoundObjectController() NN_NOEXCEPT :
m_LastError(viewer::ResultType_True),
m_IsInitialized(false)
{
}

//----------------------------------------------------------
viewer::Result
SoundObjectController::Initialize(SoundArchivePlayer* soundArchivePlayer) NN_NOEXCEPT
{
    if(soundArchivePlayer == NULL)
    {
        NN_SDK_ASSERT(false, "invalid arguments.\n");
        SetLastError(viewer::ResultType_Failed);
        return viewer::Result(viewer::ResultType_Failed);
    }

    for(uint32_t index = 0; index < SoundControllerCount; ++index)
    {
        viewer::Result result = m_SoundController[index].Initialize(
            &m_SoundHandles[index],
            soundArchivePlayer);

        if(result.IsFailed())
        {
            Finalize();
            SetLastError(result);
            return result;
        }
    }

    m_IsInitialized = true;

    return viewer::Result(viewer::ResultType_True);
}

//----------------------------------------------------------
void
SoundObjectController::Finalize() NN_NOEXCEPT
{
    for(uint32_t index = 0; index < SoundControllerCount; ++index)
    {
        m_SoundController[index].Finalize();
    }

    m_IsInitialized = false;
}

//----------------------------------------------------------
void
SoundObjectController::Update() NN_NOEXCEPT
{
    NN_SDK_ASSERT(IsInitialized(), "SoundObjectController is not initialized.\n");

    for(uint32_t index = 0; index < SoundControllerCount; ++index)
    {
        m_SoundController[index].Update();
    }
}

//----------------------------------------------------------
void
SoundObjectController::SetLastError(viewer::ResultType value) NN_NOEXCEPT
{
    m_LastError = viewer::Result(value);

#if defined(NN_ATK_ENABLE_ERROR_DEBUG)
    NN_DETAIL_ATK_INFO("[sndctrl] SoundObjectController::SetLastError '%s'.\n", viewer::Result(value).ToString());
#endif
}

} // namespace nn::atk::viewer
} // namespace nn::atk
} // namespace nn

#endif // NN_ATK_CONFIG_ENABLE_DEV
