﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_Task.h>

namespace nn {
namespace atk {
namespace detail {

Task::Task() NN_NOEXCEPT
: m_Event(nn::os::EventClearMode_ManualClear)
, m_Status(Status_Free)
, m_Id(0)
{
    m_Event.Signal();
}

Task::~Task() NN_NOEXCEPT
{
    NN_SDK_ASSERT( m_Status != Status_Append && m_Status != Status_Execute );
}

} // namespace nn::atk::detail
} // namespace nn::atk
} // namespace nn

