﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_MmlSequenceTrackAllocator.h>

namespace nn {
namespace atk {
namespace detail {
namespace driver {

/* ========================================================================
        static member function
   ======================================================================== */


/*--------------------------------------------------------------------------------*
  Name:         AllocTrack

  Description:  トラックを確保します

  Arguments:    None.

  Returns:      確保できたときは、トラックID
                確保できなかったときは、-1 を返します
 *--------------------------------------------------------------------------------*/
SequenceTrack* MmlSequenceTrackAllocator::AllocTrack( SequenceSoundPlayer* player ) NN_NOEXCEPT
{
    MmlSequenceTrack* track = m_TrackPool.Alloc();
    if ( track != NULL )
    {
        track->SetSequenceSoundPlayer( player );
        track->SetMmlParser( m_pParser );
    }
    return track;
}

/*--------------------------------------------------------------------------------*
  Name:         FreeTrack

  Description:  トラックを開放します

  Arguments:    trackID - トラックID

  Returns:      None.
 *--------------------------------------------------------------------------------*/
void MmlSequenceTrackAllocator::FreeTrack( SequenceTrack* track ) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL( track );

    track->SetSequenceSoundPlayer( NULL );

    m_TrackPool.Free( reinterpret_cast<MmlSequenceTrack*>( track ) ); // TODO: 気になるキャスト
}

int MmlSequenceTrackAllocator::Create( void* buffer, size_t size ) NN_NOEXCEPT
{
    return m_TrackPool.Create( buffer, size );
}

void MmlSequenceTrackAllocator::Destroy() NN_NOEXCEPT
{
    m_TrackPool.Destroy();
}

} // namespace nn::atk::detail::driver
} // namespace nn::atk::detail
} // namespace nn::atk
} // namespace nn

