﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/atk/atk_BasicSoundPlayer.h>

namespace nn {
namespace atk {
namespace detail {
namespace driver {

void PlayerParamSet::Initialize() NN_NOEXCEPT
{
    volume = 1.0f;
    pitch = 1.0f;
    lpfFreq = 0.0f;

    biquadType = BiquadFilterType_Inherit;
    biquadValue = 0.0f;

    panMode = PanMode_Dual;
    panCurve = PanCurve_Sqrt;

    outputLineFlag = OutputLine_Main;
    tvParam.Initialize();
}

BasicSoundPlayer::BasicSoundPlayer() NN_NOEXCEPT
: m_Event(nn::os::EventClearMode_ManualClear)
, m_pOutputReceiver(nullptr)
, m_ActiveFlag(false)
, m_StartedFlag(false)
, m_PauseFlag(false)
, m_FinishFlag(false)
, m_IsFinalizedForCannotAllocateResource(false)
, m_pTvAdditionalParam( nullptr )
{
    m_Event.Signal();
}

void BasicSoundPlayer::Initialize(OutputReceiver* pOutputReceiver) NN_NOEXCEPT
{
    m_ActiveFlag = false;
    m_StartedFlag = false;
    m_PauseFlag = false;
    m_FinishFlag = false;
    m_IsFinalizedForCannotAllocateResource = false;
    m_pOutputReceiver = pOutputReceiver;

    m_PlayerParamSet.Initialize();
    m_pPlayerHeapDataManager = NULL;
}

void BasicSoundPlayer::Finalize() NN_NOEXCEPT
{
    if( m_pOutputReceiver != nullptr )
    {
        m_pOutputReceiver->AddReferenceCount( -1 );
        m_pOutputReceiver = nullptr;
    }
    m_Event.Signal();
}

void BasicSoundPlayer::SetBiquadFilter( int type, float value ) NN_NOEXCEPT
{
    NN_SDK_ASSERT( type >= BiquadFilterType_Min && type <= BiquadFilterType_Max );
    NN_SDK_ASSERT( value >= 0.0f && value <= 1.0f );

    m_PlayerParamSet.biquadType = static_cast<int8_t>( type );
    m_PlayerParamSet.biquadValue = value;
}

} // namespace nn::atk::detail::driver
} // namespace nn::atk::detail
} // namespace nn::atk
} // namespace nn

