﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/audio/audio_SubMixTypes.h>
#include <nn/atk2/atk2_OutputMixer.h>

namespace nn { namespace atk2 {

namespace detail {
    class RendererManager;
}

//! @internal
class SubMix : public OutputMixer
{
public:
    //! @internal
    SubMix() NN_NOEXCEPT;

    //! @internal
    static size_t GetRequiredMemorySize(int channelCount) NN_NOEXCEPT;
    //! @internal
    static size_t GetRequiredMemorySize(int busCount, int channelCount) NN_NOEXCEPT;
    //! @internal
    //! チャンネル数 channelCount のバスを 1 コ持つサブミックスとして初期化します。
    bool Initialize(detail::RendererManager* pRendererManager, int channelCount, void* buffer, size_t bufferSize) NN_NOEXCEPT;
    //! @internal
    //! チャンネル数 channelCount のバスを busCount コ持つサブミックスとして初期化します。
    bool Initialize(detail::RendererManager* pRendererManager, int busCount, int channelCount, void* buffer, size_t bufferSize) NN_NOEXCEPT;
    //! @internal
    //! 終了処理します。
    //! 終了処理では、このサブミックスが内部で確保したサブミックスインスタンスとミックスバッファを解放します。
    //! 解放されたサブミックスインスタンスとミックスバッファは、他のサブミックスで再利用することができます。
    void Finalize(detail::RendererManager* pRendererManager) NN_NOEXCEPT;
    //! @internal
    //! サブミックスを削除可能かどうかを取得します。
    bool IsRemovable() const NN_NOEXCEPT;

    //! @internal
    void Update() NN_NOEXCEPT;
    //! @internal
    void UpdateBusVolume(int bus) NN_NOEXCEPT;

    //! @internal
    //! サブミックスの出力先を設定します。
    void SetDestination(detail::RendererManager* pRendererManager, OutputReceiver* pReceiver) NN_NOEXCEPT;

    //! @internal
    void SetBusVolume(int bus, float volume, int fadeFrame) NN_NOEXCEPT;
    //! @internal
    float GetBusVolume(int bus) const NN_NOEXCEPT;
    //! @internal
    void SetBusMute(int bus, bool isMute) NN_NOEXCEPT;
    //! @internal
    bool IsBusMuted(int bus) const NN_NOEXCEPT;

    //! @internal
    void SetMixVolume(int srcBus, int srcChannel, int dstBus, int dstChannel, float volume) NN_NOEXCEPT;
    //! @internal
    float GetMixVolume(int srcBus, int srcChannel, int dstBus, int dstChannel) const NN_NOEXCEPT;
    //! @internal
    void SetMixVolumeImpl(int srcBus, int srcChannel, int dstBus, int dstChannel, float volume) NN_NOEXCEPT;

    //! @internal
    void SetMuteUnusedEffectChannel(bool isUnusedEffectChannelMuted) NN_NOEXCEPT;
    //! @internal
    bool IsUnusedEffectChannelMuted() const NN_NOEXCEPT;

    //! @internal
    //void SetupEffect(EffectBase* pEffect, int bus) NN_NOEXCEPT NN_OVERRIDE;
    //! @internal
    //void SetupEffect(EffectAux* pEffect, int bus) NN_NOEXCEPT NN_OVERRIDE;

    //! @internal
    virtual ReceiverType GetReceiverType() const NN_NOEXCEPT NN_OVERRIDE;
    //! @internal
    virtual int GetChannelCount() const NN_NOEXCEPT NN_OVERRIDE;
    //! @internal
    virtual int GetBusCount() const NN_NOEXCEPT NN_OVERRIDE;
    //! @internal
    inline nn::audio::SubMixType* GetAudioSubMixInstance() NN_NOEXCEPT
    {
        NN_SDK_ASSERT( m_IsInitialized );
        return &m_SubMix;
    }
    //! @internal
    inline const nn::audio::SubMixType* GetAudioSubMixInstance() const NN_NOEXCEPT
    {
        NN_SDK_ASSERT( m_IsInitialized );
        return &m_SubMix;
    }
    //! @internal
    virtual void AddReferenceCount(int value) NN_NOEXCEPT NN_OVERRIDE;

private:
    //void MuteUnusedEffectChannel(ChannelIndex* effectChannelIndex, int effectChannelCount, int bus) NN_NOEXCEPT;

private:
    nn::audio::SubMixType m_SubMix;
    std::atomic<uint32_t> m_ReferenceCount;
    OutputReceiver* m_pReceiver;

    struct BusData
    {
        //detail::MoveValue<float,int> volume;
        bool isMute;
        bool isPrevMute;
    };
    BusData* m_pBusData;

    float** m_ppMixVolume;

    int m_ChannelCount;
    int m_BusCount;
    bool m_IsInitialized;
    bool m_IsUnusedEffectChannelMuted;
};

}}
