﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//---------------------------------------------------------------------------
//! @namespace nn::atk2
//!
//! @brief    Audio Toolkit 2 の名前空間です。
//!
//! @attention 本名前空間の API を利用するには、
//!            NintendoSDK NintendoWare パッケージをインストールする必要があります。
//---------------------------------------------------------------------------

#include <nn/atk2/atk2_AudioEngine.h>
#include <nn/atk2/atk2_IAudioFrameUpdate.h>
#include <nn/atk2/atk2_FinalMix.h>
#include <nn/atk2/atk2_SubMix.h>
#include <nn/atk2/atk2_OutputMixer.h>
#include <nn/atk2/atk2_OutputReceiver.h>
#include <nn/atk2/detail/atk2_Adpcm.h>
#include <nn/atk2/detail/atk2_AudioFrameUpdater.h>
#include <nn/atk2/detail/atk2_AudioThread.h>
#include <nn/atk2/detail/atk2_CommandManager.h>
#include <nn/atk2/detail/atk2_Filter.h>
#include <nn/atk2/detail/atk2_RendererManager.h>
#include <nn/atk2/detail/atk2_RendererVoice.h>
#include <nn/atk2/detail/atk2_RendererVoiceManager.h>
#include <nn/atk2/detail/atk2_VirtualVoiceManager.h>
#include <nn/atk2/detail/atk2_Voice.h>
#include <nn/atk2/detail/atk2_VoiceCommandManager.h>
#include <nn/atk2/detail/atk2_VoiceReplyCommandManager.h>
#include <nn/atk2/detail/atk2_WaveBuffer.h>
#include <nn/atk2/detail/atk2_WaveBufferList.h>
#include <nn/atk2/detail/fnd/atk2_CriticalSection.h>
#include <nn/atk2/detail/fnd/atk2_Thread.h>
