﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/atk/atk_Global.h>      // AuxBus_Count

namespace nn {
namespace atk {
namespace detail {

struct WaveSoundInfo;
struct WaveSoundNoteInfo;

class IWaveSoundFileReader
{
public:
    virtual void Initialize( const void* waveSoundFile ) NN_NOEXCEPT = 0;
    virtual bool IsAvailable() const NN_NOEXCEPT = 0;

    virtual uint32_t GetWaveSoundCount() const NN_NOEXCEPT = 0;
    virtual uint32_t GetNoteInfoCount( uint32_t index ) const NN_NOEXCEPT = 0;
    virtual uint32_t GetTrackInfoCount( uint32_t index ) const NN_NOEXCEPT = 0;

    virtual bool ReadWaveSoundInfo( WaveSoundInfo* dst, uint32_t index ) const NN_NOEXCEPT = 0;
    virtual bool ReadNoteInfo( WaveSoundNoteInfo* dst, uint32_t index, uint32_t noteIndex ) const NN_NOEXCEPT = 0;

protected:
    virtual ~IWaveSoundFileReader() NN_NOEXCEPT { }
};

} // namespace nn::atk::detail
} // namespace nn::atk
} // namespace nn
