﻿using System;
using System.Collections.Generic;
using System.Linq;
using SdkEnvironmentCheckerLibrary.Checkers;

namespace SdkEnvironmentCheckerLibrary
{
    public static class SdkEnvironmentChecker
    {
        public static IEnumerable<CheckerResult> Check(SdkEnvironmentCheckerInfo checkerInfo)
        {
            if (checkerInfo == null) throw new ArgumentNullException(nameof(checkerInfo));

            if (checkerInfo.OsVersions.Any())
            {
                yield return OsVersionChecker.Check(checkerInfo.OsVersions);
            }

            if (checkerInfo.DotNetFrameworkVersion != null)
            {
                yield return DotNetFrameworkVersionChecker.Check(checkerInfo.DotNetFrameworkVersion);
            }

            if (checkerInfo.NvnGraphicsDriver)
            {
                yield return NvnGraphicsDriverChecker.Check();
            }

            foreach (var installedProgramVersion in checkerInfo.InstalledProgramVersions)
            {
                yield return InstalledProgramVersionChecker.Check(installedProgramVersion);
            }
        }
    }

    public class SdkEnvironmentCheckerInfo
    {
        public IList<OsVersionInfo> OsVersions { get; } = new NotNullList<OsVersionInfo>();

        public DotNetFrameworkVersionInfo DotNetFrameworkVersion { get; set; }

        public bool NvnGraphicsDriver { get; set; }

        public IList<InstalledProgramVersionInfo> InstalledProgramVersions { get; } = new NotNullList<InstalledProgramVersionInfo>();
    }
}
