﻿using System;
using System.ComponentModel;
using System.Globalization;

namespace SdkEnvironmentCheckerLibrary
{
    public class VersionTypeConverter : TypeConverter
    {
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType) => sourceType == typeof(string);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value)
            => Version.TryParse(value as string, out var version) ? version : null;

        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType) => destinationType == typeof(string);
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType) => value?.ToString();
    }
}
