﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;

namespace QCIT_Maker
{
    internal class Program
    {
        private static void Main(string[] args)
        {
            var opt = new Arguments();
            try
            {
                if (!opt.ParseArgs(args))
                {
                    Environment.ExitCode = 1;
                    return;
                }
            }
            catch (Exception err)
            {
                Console.Error.WriteLine(err.Message);
                Environment.ExitCode = 1;
                return;
            }

            var srv = new Service(opt.Params);
            try
            {
                // 入力引数のチェックと作業ディレクトリと出力用ディレクトリの準備処理
                srv.InitInputFileParams();
            }
            catch (Exception err)
            {
                Console.Error.WriteLine(err.StackTrace);
                Console.Error.WriteLine(err.Message);
                Environment.ExitCode = 1;
                return;
            }

            try
            {
                var sw = new Stopwatch(); // 処理時間計測用
                sw.Start();

                // ツールのメイン処理を実行
                srv.CreateQCIT();

                sw.Stop();
                // 処理の並列化に伴い、最終的に全体の処理時間のみを出力させる
                Console.WriteLine("--ElapsedTime: {0} --", sw.Elapsed);
            }
            catch (Exception err)
            {
                Console.Error.WriteLine(err.StackTrace);
                Console.Error.WriteLine(err.Message);
                Environment.ExitCode = 1;
            }

            // 後処理として作業フォルダの掃除
            srv.ClearWorkSpace();
        }
    }
}
