﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace BackupRestoreGui
{
    class Script
    {
        public static string GetPath(ToolMode mode, bool isDevelop, bool isSigned)
        {
            if (isDevelop)
            {
                switch (mode)
                {
                    case ToolMode.Backup:
                        if (isSigned)
                        {
                            return new FileInfo(Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate/Scripts/NX/Repair/BackupTool-InstallAndLaunch-Dev-Signed.bat")).FullName;
                        }
                        else
                        {
                            return new FileInfo(Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate/Scripts/NX/Repair/BackupTool-InstallAndLaunch-Dev.bat")).FullName;
                        }
                    case ToolMode.Restore:
                        if (isSigned)
                        {
                            return new FileInfo(Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate/Scripts/NX/Repair/RestoreTool-InstallAndLaunch-Dev-Signed.bat")).FullName;
                        }
                        else
                        {
                            return new FileInfo(Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate/Scripts/NX/Repair/RestoreTool-InstallAndLaunch-Dev.bat")).FullName;
                        }

                    default:
                        throw new Exception("unknown mode");
                }
            }
            else
            {
                switch (mode)
                {
                    case ToolMode.Backup:
                        return new FileInfo(Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate/Scripts/NX/Repair/BackupTool-InstallAndLaunch-Prod.bat")).FullName;
                    case ToolMode.Restore:
                        return new FileInfo(Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate/Scripts/NX/Repair/RestoreTool-InstallAndLaunch-Prod.bat")).FullName;
                    default:
                        throw new Exception("unknown mode");
                }
            }
        }

        public static string GetFrcmPath(bool isDevelop, bool isForceInstall, bool isSigned)
        {
            if (isDevelop)
            {
                if (isForceInstall)
                {
                    if (isSigned)
                    {
                        return new FileInfo(Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate/Scripts/NX/Repair/FrcmSystemInstallerForcibly-Dev-Signed.bat")).FullName;
                    }
                    else
                    {
                        return new FileInfo(Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate/Scripts/NX/Repair/FrcmSystemInstallerForcibly-Dev.bat")).FullName;
                    }
                }
                else
                {
                    if (isSigned)
                    {
                        return new FileInfo(Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate/Scripts/NX/Repair/FrcmSystemInstaller-Dev-Signed.bat")).FullName;
                    }
                    else
                    {
                        return new FileInfo(Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate/Scripts/NX/Repair/FrcmSystemInstaller-Dev.bat")).FullName;
                    }
                }
            }
            else
            {
                if (isForceInstall)
                {
                    return new FileInfo(Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate/Scripts/NX/Repair/FrcmSystemInstallerForcibly-Prod.bat")).FullName;
                }
                else
                {
                    return new FileInfo(Path.Combine(CommandUtility.SdkPath.FindSdkRoot(), "Integrate/Scripts/NX/Repair/FrcmSystemInstaller-Prod.bat")).FullName;
                }
            }
        }
    }
}
