﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "VibrationAmFmCodecLib.h"

namespace Nintendo { namespace VibrationAmFmCodec {

public enum class AmFmCommandTable
{
    None,
    FiveBitVer1,
    FiveBitVer2,
};

public ref class AmFmDecoder
{
public:
    AmFmDecoder();
    AmFmDecoder(AmFmCommandTable table, float baseFrequency);
    virtual ~AmFmDecoder();
    !AmFmDecoder();

    void TryDecode(
        [System::Runtime::InteropServices::OutAttribute] float % amplitude,
        [System::Runtime::InteropServices::OutAttribute] float % frequency,
        int amfmCode);
    void Decode(int amfmCode);
    void Reset(AmFmCommandTable table, float baseFrequency);
    float GetAmplitude();
    float GetFrequency();

private:
    float m_Amplitude;
    float m_Frequency;
    float m_BaseFrequency;
    nn::xcd::VibrationAmFmDecoderContext* m_pContext;
};

public ref class AmFmEncoder
{
public:
    AmFmEncoder();
    AmFmEncoder(float baseFrequency);
    virtual ~AmFmEncoder();
    !AmFmEncoder();

    void Reset(float baseFrequency);
    int GetAmFmCode(float amplitude, float frequency);

private:
    float m_BaseFrequency;
    nn::xcd::VibrationAmFmEncoderContext* m_pContext;
};

}} // namespace Nintendo::VibrationAmFmCodec
