﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    using System;

    /// <summary>
    /// ゲームパッドのボタンの定義です。
    /// </summary>
    [Flags]
    internal enum GamePadButtons : uint
    {
        /// <summary>
        /// 無し
        /// </summary>
        None = 0,

        /// <summary>
        /// A ボタン
        /// </summary>
        A = 1u,

        /// <summary>
        /// B ボタン
        /// </summary>
        B = 1u << 1,

        /// <summary>
        /// X ボタン
        /// </summary>
        X = 1u << 2,

        /// <summary>
        /// Y ボタン
        /// </summary>
        Y = 1u << 3,

        /// <summary>
        /// L スティックポタン
        /// </summary>
        StickL = 1u << 4,

        /// <summary>
        /// R スティックポタン
        /// </summary>
        StickR = 1u << 5,

        /// <summary>
        /// L ボタン
        /// </summary>
        L = 1u << 6,

        /// <summary>
        /// R ボタン
        /// </summary>
        R = 1u << 7,

        /// <summary>
        /// ZL ボタン
        /// </summary>
        ZL = 1u << 8,

        /// <summary>
        /// ZR ボタン
        /// </summary>
        ZR = 1u << 9,

        /// <summary>
        /// Plus ボタン
        /// </summary>
        Plus = 1u << 10,

        /// <summary>
        /// Minus ボタン
        /// </summary>
        Minus = 1u << 11,

        /// <summary>
        /// 十字ボタン 左
        /// </summary>
        Left = 1u << 12,

        /// <summary>
        /// 十字ボタン 上
        /// </summary>
        Up = 1u << 13,

        /// <summary>
        /// 十字ボタン 右
        /// </summary>
        Right = 1u << 14,

        /// <summary>
        /// 十字ボタン 下
        /// </summary>
        Down = 1u << 15,
    }
}
