﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace InputDirector
{
    using System.Runtime.Serialization;

    /// <summary>
    /// 通信設定です。
    /// </summary>
    [DataContract]
    internal sealed class ConnectionConfig
    {
        /// <summary>
        /// ConnectionConfig クラスの新しいインスタンスを初期化します。
        // </summary>
        internal ConnectionConfig()
        {
        }

        /// <summary>
        /// ConnectionConfig クラスの新しいインスタンスを指定された通信設定に基づいて初期化します。
        /// </summary>
        /// <param name="config">通信設定です。</param>
        internal ConnectionConfig(ConnectionConfig config)
        {
            this.IsAutoConnectionEnabled = config.IsAutoConnectionEnabled;

            this.IsTimeoutEnabled = config.IsTimeoutEnabled;

            this.Timeout = config.Timeout;

            this.PollingInterval = config.PollingInterval;
        }

        /// <summary>
        /// 自動接続を有効化するか否かを表す値を取得または設定します。
        /// </summary>
        [DataMember]
        internal bool IsAutoConnectionEnabled { get; set; } = true;

        /// <summary>
        /// タイムアウトを有効化するか否かを表す値を取得または設定します。
        /// </summary>
        [DataMember]
        internal bool IsTimeoutEnabled { get; set; } = true;

        /// <summary>
        /// タイムアウトまでの時間間隔 (ミリ秒) を取得または設定します。
        /// </summary>
        [DataMember]
        internal int Timeout { get; set; } = 1000;

        /// <summary>
        /// ポーリングのまでの時間間隔 (ミリ秒) を取得または設定します。
        /// </summary>
        [DataMember]
        internal int PollingInterval { get; set; } = 100;
    }
}
