﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "HidShellLibrary.h"

#define HID_SHELL_RESULT_SUCCESS \
    return HidShellResult::Success

#define HID_SHELL_RESULT_THROW(r) \
    return r

#define HID_SHELL_RESULT_THROW_UNLESS(condition, r) \
    do \
    { \
        if (!(condition)) \
        { \
            HID_SHELL_RESULT_THROW(r); \
        } \
    } while (NN_STATIC_CONDITION(0))

#define HID_SHELL_RESULT_DO(r) \
    do \
    { \
        const HidShellResult _hid_shell_result = r; \
        if (_hid_shell_result != HidShellResult::Success) \
        { \
            HID_SHELL_RESULT_THROW(_hid_shell_result); \
        } \
    } while (NN_STATIC_CONDITION(0))
