﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "HidShellLibrary.h"

//!< HidShell の IO ポートの占有権を取得します。
HidShellResult AquireHidShellIoPortExclusiveRight(
    HidShellHandle* pOutHandle) NN_NOEXCEPT;

//!< HidShell の IO ポートの占有権を開放します。
HidShellResult ReleaseHidShellIoPortExclusiveRight(
    HidShellHandle handle) NN_NOEXCEPT;

//!< HidShell の IO ポートをアタッチします。
HidShellResult AttachHidShellIoPort(
    HidShellHandle handle, const HidShellPortName& name) NN_NOEXCEPT;

//!< HidShell の IO ポートをデタッチします。
HidShellResult DetachHidShellIoPort(
    HidShellHandle handle, const HidShellPortName& name) NN_NOEXCEPT;

//!< HidShell の IO ポートを取得します。
HidShellResult GetHidShellIoPort(
    HidShellHandle handle,
    uint32_t* pOutPort, const HidShellPortName& name) NN_NOEXCEPT;

//!< HidShell の IO ポートリストを取得します。
HidShellResult GetHidShellIoPortList(
    HidShellHandle handle, HidShellPortList* pOutList) NN_NOEXCEPT;

//!< HidShell の IO ポートから撮影ボタンの入力状態を取得します。
HidShellResult GetHidShellIoPortCaptureButtonState(
    HidShellHandle handle,
    HidShellCaptureButtonState* pOutValue,
    uint32_t port, HidShellPortDirection direction) NN_NOEXCEPT;

//!< HidShell の IO ポートに撮影ボタンの入力状態を設定します。
HidShellResult SetHidShellIoPortCaptureButtonState(
    HidShellHandle handle,
    const HidShellCaptureButtonState& value,
    uint32_t port, HidShellPortDirection direction) NN_NOEXCEPT;

//!< HidShell の IO ポートからデバッグパッドの入力状態を取得します。
HidShellResult GetHidShellIoPortDebugPadState(
    HidShellHandle handle,
    HidShellDebugPadState* pOutValue,
    uint32_t port, HidShellPortDirection direction) NN_NOEXCEPT;

//!< HidShell の IO ポートにデバッグパッドの入力状態を設定します。
HidShellResult SetHidShellIoPortDebugPadState(
    HidShellHandle handle,
    const HidShellDebugPadState& value,
    uint32_t port, HidShellPortDirection direction) NN_NOEXCEPT;

//!< HidShell の IO ポートからホームボタンの入力状態を取得します。
HidShellResult GetHidShellIoPortHomeButtonState(
    HidShellHandle handle,
    HidShellHomeButtonState* pOutValue,
    uint32_t port, HidShellPortDirection direction) NN_NOEXCEPT;

//!< HidShell の IO ポートにホームボタンの入力状態を設定します。
HidShellResult SetHidShellIoPortHomeButtonState(
    HidShellHandle handle,
    const HidShellHomeButtonState& value,
    uint32_t port, HidShellPortDirection direction) NN_NOEXCEPT;

//!< HidShell の IO ポートからタッチパネルの入力状態を取得します。
HidShellResult GetHidShellIoPortTouchScreenState(
    HidShellHandle handle,
    HidShellTouchScreenState* pOutValue,
    uint32_t port, HidShellPortDirection direction) NN_NOEXCEPT;

//!< HidShell の IO ポートにタッチパネルの入力状態を設定します。
HidShellResult SetHidShellIoPortTouchScreenState(
    HidShellHandle handle,
    const HidShellTouchScreenState& value,
    uint32_t port, HidShellPortDirection direction) NN_NOEXCEPT;

//!< HidShell の IO ポートから基本的な構成を持つ Xpad の入力状態を取得します。
HidShellResult GetHidShellIoPortBasicXpadState(
    HidShellHandle handle,
    HidShellBasicXpadState* pOutValue, uint32_t id,
    uint32_t port, HidShellPortDirection direction) NN_NOEXCEPT;

//!< HidShell の IO ポートに基本的な構成を持つ Xpad の入力状態を設定します。
HidShellResult SetHidShellIoPortBasicXpadState(
    HidShellHandle handle,
    const HidShellBasicXpadState& value, uint32_t id,
    uint32_t port, HidShellPortDirection direction) NN_NOEXCEPT;

//!< HidShell の IO ポートから基本的な構成を持つ AbstractedPad の入力状態を取得します。
HidShellResult GetHidShellIoPortAbstractedPadState(
    HidShellHandle handle,
    HidShellAbstractedPadState* pOutValue, uint32_t id,
    uint32_t port, HidShellPortDirection direction) NN_NOEXCEPT;

//!< HidShell の IO ポートに基本的な構成を持つ AbstractedPad の入力状態を設定します。
HidShellResult SetHidShellIoPortAbstractedPadState(
    HidShellHandle handle,
    const HidShellAbstractedPadState& value, uint32_t id,
    uint32_t port, HidShellPortDirection direction) NN_NOEXCEPT;
