﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace InputCapture.Windows.Forms
{
    using System;
    using System.ComponentModel;
    using System.IO;
    using System.Reflection;
    using System.Windows.Forms;

    /// <summary>
    /// InputCapture アプリケーションです。
    /// </summary>
    public class InputCaptureApp : Form
    {
        CaptureManager _capture = null;
        SettingsForm _settingForm = null;
        private NotifyIcon notifyIcon1;
        private ContextMenuStrip contextMenuStrip1;
        private ToolStripMenuItem settingsToolStripMenuItem;
        private ToolStripSeparator toolStripMenuItem1;
        private ToolStripMenuItem exitToolStripMenuItem;
        private ToolStripMenuItem connectToolStripMenuItem;
        private ToolStripMenuItem aboutToolStripMenuItem;
        private IContainer components;

        // 英語ＵＩモード
        public static bool IsEnglishUI { get; private set; }

        public InputCaptureApp()
        {
            InitApp();

            //
            // Windows フォーム デザイナ サポートに必要です。
            //
            InitializeComponent();

            //
            // TODO: InitializeComponent 呼び出しの後に、コンストラクタ コードを追加してください。
            //

            Application.ApplicationExit += new EventHandler(Application_ApplicationExit);

            _capture = new CaptureManager();

            notifyIcon1.ShowBalloonTip(
                3000,
                Resources.Strings.BalloonTip_TipTitle,
                Resources.Strings.BalloonTip_TipText_Resident,
                ToolTipIcon.Info);
        }

        private void InitApp()
        {
            // アプリケーション初期設定。
            // TODO:ローカライズ対応時に
            string root = "INPUT_CAPTURE_ROOT";
            if (Environment.GetEnvironmentVariable(root) == null)
            {
                string relativePath = @".";

                Assembly assembly = Assembly.GetEntryAssembly();
                string executableDirectory = Path.GetDirectoryName(assembly.Location);
                if (string.Compare(Path.GetFileName(executableDirectory), "Debug", true) == 0 ||
                    string.Compare(Path.GetFileName(executableDirectory), "Release", true) == 0)
                {
                    relativePath = @"..\..\..\";
                }

                string path = Path.Combine(executableDirectory, relativePath);
                try
                {
                    path = Path.GetFullPath(path);
                }
                catch (Exception)
                {
                }
                Environment.SetEnvironmentVariable(root, path);
            }

            // ＵＩ言語初期化
            if (File.Exists(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + "\\en\\InputCapture.resources.dll"))
            {
                System.Threading.Thread.CurrentThread.CurrentUICulture = new System.Globalization.CultureInfo("en", false);
                IsEnglishUI = true;
            }
        }

        private void Application_ApplicationExit(object sender, EventArgs e)
        {
            _capture.Dispose();
            _capture = null;
        }

        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        #region Windows フォーム デザイナで生成されたコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(InputCaptureApp));
            this.notifyIcon1 = new System.Windows.Forms.NotifyIcon(this.components);
            this.contextMenuStrip1 = new System.Windows.Forms.ContextMenuStrip(this.components);
            this.connectToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.settingsToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.aboutToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem1 = new System.Windows.Forms.ToolStripSeparator();
            this.exitToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.contextMenuStrip1.SuspendLayout();
            this.SuspendLayout();
            //
            // notifyIcon1
            //
            this.notifyIcon1.ContextMenuStrip = this.contextMenuStrip1;
            resources.ApplyResources(this.notifyIcon1, "notifyIcon1");
            //
            // contextMenuStrip1
            //
            this.contextMenuStrip1.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.connectToolStripMenuItem,
            this.settingsToolStripMenuItem,
            this.aboutToolStripMenuItem,
            this.toolStripMenuItem1,
            this.exitToolStripMenuItem});
            this.contextMenuStrip1.Name = "contextMenuStrip1";
            resources.ApplyResources(this.contextMenuStrip1, "contextMenuStrip1");
            this.contextMenuStrip1.Opening += new System.ComponentModel.CancelEventHandler(this.contextMenuStrip1_Opening);
            //
            // connectToolStripMenuItem
            //
            this.connectToolStripMenuItem.CheckOnClick = true;
            this.connectToolStripMenuItem.Name = "connectToolStripMenuItem";
            resources.ApplyResources(this.connectToolStripMenuItem, "connectToolStripMenuItem");
            this.connectToolStripMenuItem.Click += new System.EventHandler(this.connectToolStripMenuItem_Click);
            //
            // settingsToolStripMenuItem
            //
            this.settingsToolStripMenuItem.Name = "settingsToolStripMenuItem";
            resources.ApplyResources(this.settingsToolStripMenuItem, "settingsToolStripMenuItem");
            this.settingsToolStripMenuItem.Click += new System.EventHandler(this.settingsToolStripMenuItem_Click);
            //
            // aboutToolStripMenuItem
            //
            this.aboutToolStripMenuItem.Name = "aboutToolStripMenuItem";
            resources.ApplyResources(this.aboutToolStripMenuItem, "aboutToolStripMenuItem");
            this.aboutToolStripMenuItem.Click += new System.EventHandler(this.aboutToolStripMenuItem_Click);
            //
            // toolStripMenuItem1
            //
            this.toolStripMenuItem1.Name = "toolStripMenuItem1";
            resources.ApplyResources(this.toolStripMenuItem1, "toolStripMenuItem1");
            //
            // exitToolStripMenuItem
            //
            this.exitToolStripMenuItem.Name = "exitToolStripMenuItem";
            resources.ApplyResources(this.exitToolStripMenuItem, "exitToolStripMenuItem");
            this.exitToolStripMenuItem.Click += new System.EventHandler(this.exitToolStripMenuItem_Click);
            //
            // InputCaptureApp
            //
            resources.ApplyResources(this, "$this");
            this.Name = "InputCaptureApp";
            this.contextMenuStrip1.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion

        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            // 二重起動の禁止。
            System.Threading.Mutex mutex = new System.Threading.Mutex(false, "InputCapture");
            if (mutex.WaitOne(0, false) == false)
            {
                return;
            }

            // VisualStyleを有効にする
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.DoEvents();

            new InputCaptureApp();
            Application.Run();

            mutex.ReleaseMutex();
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// メニュー [接続]
        /// </summary>
        private void connectToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!_capture.IsConnected)
            {
                _capture.ManualStartConnect();
            }
            else
            {
                _capture.ManualStopConnect();
            }

            connectToolStripMenuItem.Checked = _capture.IsConnected;
        }

        /// <summary>
        /// メニュー [設定]
        /// </summary>
        private void settingsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (_settingForm == null)
            {
                _capture.IsCaptureEnabled = false;
                _settingForm = new SettingsForm(_capture.UserSettings);
                _settingForm.ShowDialog();
                _settingForm = null;

                _capture.SetHotKey();
                _capture.SetConnecterSettings();
                _capture.IsCaptureEnabled = true;
            }
            else
            {
                _settingForm.Focus();
            }
        }

        /// <summary>
        /// メニュー [バージョン情報]
        /// </summary>
        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            _capture.IsCaptureEnabled = false;
            AboutDialog aboutDialog = new AboutDialog();
            aboutDialog.ShowDialog();
            _capture.IsCaptureEnabled = true;
        }

        /// <summary>
        /// メニュー [終了]
        /// </summary>
        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.notifyIcon1.Visible = false;
            Application.Exit();
        }

        /// <summary>
        /// メニューストリップが開かれたときに呼ばれる関数です。
        /// </summary>
        private void contextMenuStrip1_Opening(object sender, CancelEventArgs e)
        {
            connectToolStripMenuItem.Checked = _capture.IsConnected;
        }
    }
}
