﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//=============================================================================
// include
//=============================================================================
#include "ROpenExr.h"

using namespace std;

//=============================================================================
// texcvtr ネームスペースを開始します。
//=============================================================================
namespace nn {
namespace gfx {
namespace tool {
namespace texcvtr {

//=============================================================================
//! @brief DLL から関数を取得するためのマクロです。
//=============================================================================
#define PROC_ADDRESS(handle, name)                                   \
*reinterpret_cast<void**>(&name) = GetProcAddress(handle, #name);    \
    if (name == NULL)                                                \
    {                                                                \
        cerr << "Error: Cannot find function: " << #name << endl;    \
    }                                                                \

//-----------------------------------------------------------------------------
//! @brief 初期化します。
//-----------------------------------------------------------------------------
bool ROpenExr::Initialize(const char* dllPath)
{
    //-----------------------------------------------------------------------------
    // DLL ファイルのパスを設定します。
    if (dllPath != NULL)
    {
        m_DllPath = dllPath;
    }
    else
    {
        dllPath = m_DllPath.c_str();
    }
    //cerr << "ROpenExr: init: " << dllPath << endl;

    //-----------------------------------------------------------------------------
    // DLL をロードします。
    m_hDLL = LoadLibrary(dllPath);
    if (m_hDLL == NULL)
    {
        //cerr << "Error: Cannot load dll: " << dllPath << endl;
        return false;
    }

    //-----------------------------------------------------------------------------
    // 関数アドレスを取得します。
    PROC_ADDRESS(m_hDLL, GetExrInfo);
    PROC_ADDRESS(m_hDLL, ParseExrInfo);
    PROC_ADDRESS(m_hDLL, ReadExrAsFloat16);
    PROC_ADDRESS(m_hDLL, ParseExrAsFloat16);
    PROC_ADDRESS(m_hDLL, ReadExrAsFloat32);
    PROC_ADDRESS(m_hDLL, ParseExrAsFloat32);
    PROC_ADDRESS(m_hDLL, WriteExrFloat16);
    PROC_ADDRESS(m_hDLL, WriteExrFloat32);
    PROC_ADDRESS(m_hDLL, WriteExrFloat32AsFloat16);
    PROC_ADDRESS(m_hDLL, GetErrorString);
    PROC_ADDRESS(m_hDLL, GetErrorShiftJisString);

    if (GetExrInfo               == NULL ||
        ParseExrInfo             == NULL ||
        ReadExrAsFloat16         == NULL ||
        ParseExrAsFloat16        == NULL ||
        ReadExrAsFloat32         == NULL ||
        ParseExrAsFloat32        == NULL ||
        WriteExrFloat16          == NULL ||
        WriteExrFloat32          == NULL ||
        WriteExrFloat32AsFloat16 == NULL ||
        GetErrorString           == NULL ||
        GetErrorShiftJisString   == NULL)
    {
        Finalize();
        return false;
    }

    return true;
}

//-----------------------------------------------------------------------------
//! @brief 終了します。
//-----------------------------------------------------------------------------
void ROpenExr::Finalize()
{
    //cerr << "ROpenExr: final: " << m_hDLL << endl;

    //-----------------------------------------------------------------------------
    // DLL を解放します。
    if (m_hDLL != NULL)
    {
        FreeLibrary(m_hDLL);
        m_hDLL = NULL;
    }

    //-----------------------------------------------------------------------------
    // 関数アドレスをクリアします。
    GetExrInfo               = NULL;
    ParseExrInfo             = NULL;
    ReadExrAsFloat16         = NULL;
    ParseExrAsFloat16        = NULL;
    ReadExrAsFloat32         = NULL;
    ParseExrAsFloat32        = NULL;
    WriteExrFloat16          = NULL;
    WriteExrFloat32          = NULL;
    WriteExrFloat32AsFloat16 = NULL;
    GetErrorString           = NULL;
    GetErrorShiftJisString   = NULL;
}

//=============================================================================
// texcvtr ネームスペースを終了します。
//=============================================================================
} // texcvtr
} // tool
} // gfx
} // nn

