﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//=============================================================================
// include
//=============================================================================
#include "Common.h"
#include "NXTypes.h"

//=============================================================================
// texcvtr ネームスペースを開始します。
//=============================================================================
namespace nn {
namespace gfx {
namespace tool {
namespace texcvtr {

//=============================================================================
//! @brief NX ユーティリティのクラスです。
//=============================================================================
class NXUtility
{
protected:
    std::string m_DllPath; //!< NX ユーティリティの DLL ファイルのパスです。
    HMODULE m_hDll; //!< NX ユーティリティの DLL のインスタンスハンドルです。

public:
    ConvertTilingFunction ConvertTiling; //!< タイリングを変換する関数です。
    ReleaseTextureFunction ReleaseTexture; //!< NX テクスチャを解放する関数です。
    GetDataSizeNXFunction GetDataSizeNX; //!< タイリング変換をした場合のデータサイズを取得する関数です。
    GetMemoryPoolAlignmentFunction GetMemoryPoolAlignment; //!< メモリプールのアライメント値を取得する関数です。

public:
    //! @biref コンストラクタです。
    NXUtility()
    : m_hDll(nullptr),
      ConvertTiling(nullptr),
      ReleaseTexture(nullptr),
      GetDataSizeNX(nullptr),
      GetMemoryPoolAlignment(nullptr)
    {
    }

    //! @biref デストラクタです。
    ~NXUtility()
    {
        Finalize();
    }

    //! @biref NX ユーティリティの DLL ファイルのパスを設定します。
    //!
    //! @param[in] dllPath NX ユーティリティの DLL ファイルのパスです。
    //!
    void SetDllPath(const char* dllPath)
    {
        m_DllPath = dllPath;
    }

    //! @biref NX ユーティリティの DLL ファイルのパスを返します。
    std::string GetDllPath() const
    {
        return m_DllPath;
    }

    //! @biref 初期化します。
    //!
    //! @param[in] dllPath NX ユーティリティの DLL ファイルのパスです。
    //!                    nullptr なら SetDllPath で設定したパスを使用します。
    //!
    //! @return 処理結果を返します。
    //!
    RStatus Initialize(const char* dllPath);

    //! @biref 終了します。
    void Finalize();

    //! @biref 初期化済みなら true を返します。
    bool IsInitialized() const
    {
        return (m_hDll != nullptr);
    }
};

//=============================================================================
// texcvtr ネームスペースを終了します。
//=============================================================================
} // texcvtr
} // tool
} // gfx
} // nn

