﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace gfx {
namespace tool {
namespace texenc {

//-----------------------------------------------------------------------------
//! @brief nvtt で画像のフォーマットを変換する関数の型です。
//!
//! @param[out] pDst 変換後のデータを格納します。
//! @param[in] pSrc 変換前のデータです。
//! @param[in] dstFormat 変換後のフォーマット文字列です。
//!                      bc / astc フォーマットを指定します。
//! @param[in] srcFormat 変換前のフォーマット文字列です。
//!                      プレーンな RGBA フォーマットである必要があります。
//!                      （unorm_8_8_8_8 / snorm_8_8_8_8 / srgb_8_8_8_8 / float_32_32_32_32）
//! @param[in] quality エンコード品質文字列です。
//!                    0 / 1 / 2 / 3 の 4 段階で指定します（空文字なら 1 とみなします）。
//!                    1 が標準的な品質です。数値が大きいほど高品質となり、エンコード時間が増大します。
//!                    1_perceptual のように _perceptual を付加すると RGB に重み付けして圧縮します。
//!                    （bc1/2/3 のみ影響）
//!                    変換後が bc6 / bc7 の場合、0 と 1、2 と 3 は同じ品質です。
//!                    変換後が bc6 / bc7 以外の場合、2 と 3 は同じ品質です。
//! @param[in] encodeFlag エンコードフラグです。
//! @param[in] dimension 次元です。
//! @param[in] imageW 画像の幅です。
//! @param[in] imageH 画像の高さです。
//! @param[in] imageD 画像の奥行きです。
//! @param[in] mipCount ミップマップのレベル数です。
//!
//! @return 処理成功なら true を返します。
//-----------------------------------------------------------------------------
typedef bool (*NvttConvertFunction)(
    void* pDst,
    const void* pSrc,
    const wchar_t* dstFormat,
    const wchar_t* srcFormat,
    const wchar_t* quality,
    const int encodeFlag,
    const int dimension,
    const int imageW,
    const int imageH,
    const int imageD,
    const int mipCount
);

//-----------------------------------------------------------------------------
//! @brief nvtt で GPU によるエンコーディングが可能なら true を返す関数の型です。
//!
//! @return GPU によるエンコーディングが可能なら true を返します。
//-----------------------------------------------------------------------------
typedef bool (*NvttIsGpuEncodingAvailableFunction)();

} // texenc
} // tool
} // gfx
} // nn

