﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/gfxTool/gfxTool_ShaderConverterApi.h>

#include <gfxTool_ShaderConverterContext.h>
#include <gfxTool_ConvertArg.h>

NN_GFXTOOL_SHADERCONVERTER_API nngfxToolResultCode nngfxToolShaderConverterCreateHandle(
    nngfxToolHandle* pOutHandle, const nngfxToolShaderConverterCreateHandleArg* pArg )
{
    NN_UNUSED( pArg );
    return ( *pOutHandle = nn::gfxTool::ShaderConverterContext::Create() ) == 0 ?
        nngfxToolResultCode_Failed : nngfxToolResultCode_Succeeded;
}

NN_GFXTOOL_SHADERCONVERTER_API nngfxToolResultCode nngfxToolShaderConverterResetHandle(
    nngfxToolHandle handle )
{
    auto ptr = nn::gfxTool::ShaderConverterContext::Get( handle );
    return ptr == nullptr ? nngfxToolResultCode_InvalidHandle : ptr->Reset();
}

NN_GFXTOOL_SHADERCONVERTER_API nngfxToolResultCode nngfxToolShaderConverterConvert(
    nngfxToolShaderConverterConvertOutput* pOutput, nngfxToolHandle handle,
    const nngfxToolShaderConverterConvertArg* pArg )
{
    auto ptr = nn::gfxTool::ShaderConverterContext::Get( handle );
    return ptr == nullptr ? nngfxToolResultCode_InvalidHandle :
        ptr->Convert( pOutput, pArg );
}

NN_GFXTOOL_SHADERCONVERTER_API nngfxToolResultCode nngfxToolShaderConverterSerialize(
    void* pOutBuffer, size_t bufferSize, nngfxToolHandle handle )
{
    auto ptr = nn::gfxTool::ShaderConverterContext::Get( handle );
    return ptr == nullptr ? nngfxToolResultCode_InvalidHandle : ptr->Serialize( pOutBuffer, bufferSize );
}

NN_GFXTOOL_SHADERCONVERTER_API nngfxToolResultCode nngfxToolShaderConverterDeleteHandle(
    nngfxToolHandle handle )
{
    return nn::gfxTool::ShaderConverterContext::Delete( handle );
}

// ヘルパー API
NN_GFXTOOL_SHADERCONVERTER_API nngfxToolResultCode nngfxToolShaderConverterCreateConvertArg(
    nngfxToolShaderConverterConvertArg** ppOutConvertArg,
    const nngfxToolShaderConverterCreateConvertArgArg* pArg )
{
    auto pConvertArg = nn::gfxTool::ConvertArg::Create();
    if( pConvertArg == nullptr )
    {
        return nngfxToolResultCode_Failed;
    }
    auto result = pConvertArg->Initilaize( pArg );
    *ppOutConvertArg = pConvertArg;
    return result;
}

NN_GFXTOOL_SHADERCONVERTER_API nngfxToolResultCode nngfxToolShaderConverterDeleteConvertArg(
    nngfxToolShaderConverterConvertArg* pConvertArg )
{
    return nn::gfxTool::ConvertArg::Delete( nn::gfxTool::ConvertArg::DownCast( pConvertArg ) );
}

NN_GFXTOOL_SHADERCONVERTER_API nngfxToolResultCode nngfxToolShaderConverterSetLogStream(
    const nngfxToolSetLogStreamArg* pArg )
{
    nn::gfxTool::Logger::SetStream( nn::gfxTool::StaticCastAuto( pArg->logType ), pArg->hLogStream );
    return nngfxToolResultCode_Succeeded;
}

NN_GFXTOOL_SHADERCONVERTER_API nngfxToolResultCode nngfxToolShaderConverterGetApiVersion(
    nngfxToolApiVersion* pOutApiVersion )
{
    if( pOutApiVersion == nullptr )
    {
        return nngfxToolResultCode_InvalidArgument;
    }
    pOutApiVersion->major = nngfxToolShaderConverterVersion_Major;
    pOutApiVersion->minor = nngfxToolShaderConverterVersion_Minor;
    pOutApiVersion->micro = nngfxToolShaderConverterVersion_Micro;
    return nngfxToolResultCode_Succeeded;
}

NN_STATIC_ASSERT( sizeof( nngfxToolShaderConverterCreateHandleArg ) == 64 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderConverterConvertArg ) == 96 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderConverterConvertOutput ) == 80 );

NN_STATIC_ASSERT( sizeof( nngfxToolShaderConverterCreateConvertArgArg ) == 112 );
NN_STATIC_ASSERT( sizeof( nngfxToolShaderConverterCreateConvertArgOutput ) == 96 );
